/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.user.IGetUserHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserCreationBidRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserCreationBid;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.converter.UserResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.YesNoRS;
import com.epam.ta.reportportal.ws.model.user.UserBidRS;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetUserHandler
implements IGetUserHandler {
    private UserRepository userRepository;
    private UserResourceAssembler userResourceAssembler;
    private UserCreationBidRepository userCreationBidRepository;
    @Autowired
    private ProjectRepository projectRepository;

    @Autowired
    public GetUserHandler(UserRepository userRepo, UserCreationBidRepository userBidRepo, UserResourceAssembler userResourceAsm) {
        this.userRepository = (UserRepository)Preconditions.checkNotNull((Object)userRepo);
        this.userCreationBidRepository = (UserCreationBidRepository)Preconditions.checkNotNull((Object)userBidRepo);
        this.userResourceAssembler = (UserResourceAssembler)Preconditions.checkNotNull((Object)userResourceAsm);
    }

    public UserResource getUser(String username, Principal principal) {
        User user = this.userRepository.findOne(username.toLowerCase());
        BusinessRule.expect((Object)user, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{username});
        return this.userResourceAssembler.toResource(user);
    }

    public Iterable<UserResource> getUsers(Filter filter, Pageable pageable, String projectName) {
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, "false", "expired"));
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        String criteria = project.getUsers().stream().map(Project.UserConfig::getLogin).collect(Collectors.joining(","));
        filter.addCondition(new FilterCondition(Condition.IN, true, criteria, "login"));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{project});
        return this.userResourceAssembler.toPagedResources(this.userRepository.findByFilterExcluding((Queryable)filter, pageable, new String[]{"email"}));
    }

    public UserBidRS getBidInformation(String uuid) {
        UserCreationBid bid = (UserCreationBid)this.userCreationBidRepository.findOne((Serializable)((Object)uuid));
        UserBidRS response = new UserBidRS();
        if (null != bid) {
            response.setIsActive(true);
            response.setEmail(bid.getEmail());
            response.setId(bid.getId());
        } else {
            response.setIsActive(false);
        }
        return response;
    }

    public YesNoRS validateInfo(String username, String email) {
        if (null != username) {
            User user = this.userRepository.findOne(EntityUtils.normalizeId((String)username));
            return null != user ? new YesNoRS(true) : new YesNoRS(false);
        }
        if (null != email) {
            User user = this.userRepository.findByEmail(EntityUtils.normalizeId((String)email));
            return null != user ? new YesNoRS(true) : new YesNoRS(false);
        }
        return new YesNoRS(false);
    }

    public Map<String, UserResource.AssignedProject> getUserProjects(String userName) {
        return this.projectRepository.findUserProjects(userName).stream().collect(Collectors.toMap(Project::getName, it -> {
            UserResource.AssignedProject assignedProject = new UserResource.AssignedProject();
            assignedProject.setEntryType(it.getConfiguration().getEntryType().name());
            Project.UserConfig userConfig = ProjectUtils.findUserConfigByLogin((Project)it, (String)userName);
            assignedProject.setProjectRole(userConfig.getProjectRole().name());
            assignedProject.setProposedRole(userConfig.getProposedRole().name());
            return assignedProject;
        }));
    }

    public Iterable<UserResource> getAllUsers(Filter filter, Pageable pageable) {
        Page users = this.userRepository.findByFilter((Queryable)filter, pageable);
        return this.userResourceAssembler.toPagedResources(users);
    }

    public Iterable<UserResource> searchUsers(String term, Pageable pageable) {
        return this.userResourceAssembler.toPagedResources(this.userRepository.searchForUser(term, pageable));
    }
}

