/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.core.item.history.ITestItemsHistoryService;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.MostFailedTestCasesFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.core.widget.content.WidgetContentProvider;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="MostFailedTestCasesFilterStrategy")
public class MostFailedTestCasesFilterStrategy
implements BuildFilterStrategy {
    private static final String ALL_RUNS = "All runs";
    private static final String FAILED = "Failed";
    private static final String AFFECTED_BY = "Affected by";
    private static final String LAST_FAIL_CAPTION = "Last Failure";
    private static final String LAST_FOUND_LAUNCH = "lastLaunch";
    private static final String LAUNCH_NAME_FIELD = "launchNameFilter";
    private static final int ITEMS_COUNT_VALUE = 20;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private TestItemRepository itemRepository;
    @Autowired
    private ITestItemsHistoryService historyServiceStrategy;
    @Autowired
    private CriteriaMapFactory criteriaMapFactory;

    public Map<String, List<ChartObject>> buildFilterAndLoadContent(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        List launchHistory;
        Map<String, List<ChartObject>> result = Collections.emptyMap();
        if (contentOptions.getWidgetOptions() == null || contentOptions.getWidgetOptions().get("launchNameFilter") == null) {
            return result;
        }
        Optional lastLaunchForProject = this.launchRepository.findLastLaunch(projectName, (String)((List)contentOptions.getWidgetOptions().get("launchNameFilter")).get(0), Mode.DEFAULT.name());
        if (!lastLaunchForProject.isPresent()) {
            return result;
        }
        String criteria = new StatisticBasedContentLoader().getSystemIssueFieldName();
        if (null != contentOptions.getContentFields() && contentOptions.getContentFields().size() >= 1) {
            criteria = (String)WidgetContentProvider.transformToDBStyle((CriteriaMap)this.criteriaMapFactory.getCriteriaMap(Launch.class), (List)contentOptions.getContentFields()).get(0);
        }
        if ((launchHistory = this.historyServiceStrategy.loadLaunches(contentOptions.getItemsCount(), ((Launch)lastLaunchForProject.get()).getId(), projectName, false)).isEmpty()) {
            return result;
        }
        Map dbProcessor = this.itemRepository.getMostFailedTestCases(launchHistory, criteria);
        Map dbProcessed = this.mapAggregationConvert(dbProcessor);
        ((Launch)launchHistory.get(0)).setName((String)((List)contentOptions.getWidgetOptions().get("launchNameFilter")).get(0));
        return MostFailedTestCasesFilterStrategy.databaseDataConverter((Map)MostFailedTestCasesFilterStrategy.sortByValue((Map)dbProcessed), (int)contentOptions.getItemsCount(), (Launch)((Launch)launchHistory.get(0)));
    }

    public Map<String, List<ChartObject>> loadContentOfLatestLaunches(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        throw new ReportPortalException("Operation is not supported for this strategy");
    }

    private static Map<String, List<ChartObject>> databaseDataConverter(Map<String, ComplexValue> dbData, int launches, Launch last) {
        DecimalFormat formatter = new DecimalFormat("###.##");
        LinkedHashMap<String, List<ChartObject>> result = new LinkedHashMap<String, List<ChartObject>>();
        if (dbData.keySet().isEmpty()) {
            return result;
        }
        for (Map.Entry<String, ComplexValue> pair : dbData.entrySet()) {
            ChartObject object = new ChartObject();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("All runs", String.valueOf(pair.getValue().getTotal()));
            values.put("Failed", String.valueOf(pair.getValue().getCount()));
            double value = (double)pair.getValue().getCount().intValue() / (double)pair.getValue().getTotal().intValue() * 100.0;
            values.put("Affected by", String.valueOf(formatter.format(value)));
            values.put("Last Failure", String.valueOf(pair.getValue().getStartTime()));
            object.setValues(values);
            result.put(pair.getKey(), Lists.newArrayList((Object[])new ChartObject[]{object}));
        }
        ChartObject lastLaunch = new ChartObject();
        lastLaunch.setName(last.getName());
        lastLaunch.setNumber(last.getNumber().toString());
        lastLaunch.setId(last.getId());
        result.put("lastLaunch", Lists.newArrayList((Object[])new ChartObject[]{lastLaunch}));
        return result;
    }

    private static <K, ComplexValue extends Comparable<? super ComplexValue>> LinkedHashMap<K, ComplexValue> sortByValue(Map<K, ComplexValue> map) {
        LinkedList<Map.Entry<K, ComplexValue>> list = new LinkedList<Map.Entry<K, ComplexValue>>(map.entrySet());
        Collections.sort(list, Comparator.comparing(object -> (Comparable)object.getValue()));
        LinkedHashMap result = new LinkedHashMap();
        int counter = 0;
        for (Map.Entry entry : list) {
            if (counter >= 20) break;
            result.put(entry.getKey(), entry.getValue());
            ++counter;
        }
        return result;
    }

    private Map<String, ComplexValue> mapAggregationConvert(Map<String, String> input) {
        return input.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.valueConstrunt((String)entry.getValue())));
    }

    private ComplexValue valueConstrunt(String mapValue) {
        String[] split = mapValue.split("#");
        int value = Integer.parseInt(split[0]);
        long date = Long.parseLong(split[1]);
        int total = Integer.parseInt(split[2]);
        return new ComplexValue(value, date, total);
    }
}

