/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.statistics.StatisticSubType;
import com.epam.ta.reportportal.events.ItemIssueTypeDefined;
import com.epam.ta.reportportal.events.TicketAttachedEvent;
import com.epam.ta.reportportal.events.TicketPostedEvent;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.issue.IssueDefinition;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class TicketActivitySubscriber {
    public static final String TICKET_ID = "ticketId";
    public static final String POST_ISSUE = "post_issue";
    public static final String ATTACH_ISSUE = "attach_issue";
    public static final String UPDATE_ITEM = "update_item";
    public static final String ISSUE_TYPE = "issueType";
    public static final String COMMENT = "comment";
    private final ActivityRepository activityRepository;
    private final Provider<ActivityBuilder> activityBuilder;
    private final TestItemRepository testItemRepository;
    private final ProjectRepository projectSettingsRepository;

    @Autowired
    public TicketActivitySubscriber(ActivityRepository activityRepository, Provider<ActivityBuilder> activityBuilder, TestItemRepository testItemRepository, ProjectRepository projectSettingsRepository) {
        this.activityRepository = activityRepository;
        this.activityBuilder = activityBuilder;
        this.testItemRepository = testItemRepository;
        this.projectSettingsRepository = projectSettingsRepository;
    }

    @EventListener
    public void onTicketPosted(TicketPostedEvent event) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)event.getTestItemId()));
        String oldValue = null;
        String separator = ",";
        if (null != testItem && null != testItem.getIssue()) {
            oldValue = this.issuesIdsToString(testItem.getIssue().getExternalSystemIssues(), separator);
        }
        String newValue = null == oldValue ? event.getTicket().getId() + ":" + event.getTicket().getTicketUrl() : oldValue + separator + event.getTicket().getId() + ":" + event.getTicket().getTicketUrl();
        Activity.FieldValues fieldValues = Activity.FieldValues.newOne().withOldValue(oldValue).withNewValue(newValue);
        HashMap<String, Activity.FieldValues> history = new HashMap<String, Activity.FieldValues>();
        history.put(TICKET_ID, fieldValues);
        Activity activity = (Activity)((ActivityBuilder)this.activityBuilder.get()).addProjectRef(event.getProject()).addActionType(POST_ISSUE).addLoggedObjectRef(event.getTestItemId()).addObjectType("testItem").addUserRef(event.getPostedBy()).addHistory(history).build();
        this.activityRepository.save((Object)activity);
    }

    @EventListener
    public void onTicketAttached(TicketAttachedEvent event) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        String separator = ",";
        Iterable testItems = (Iterable)event.getBefore();
        Map<String, Activity.FieldValues> results = StreamSupport.stream(testItems.spliterator(), false).filter(item -> null != item.getIssue()).collect(Collectors.toMap(TestItem::getId, item -> Activity.FieldValues.newOne().withOldValue(this.issuesIdsToString(item.getIssue().getExternalSystemIssues(), separator))));
        Iterable updated = (Iterable)event.getAfter();
        for (TestItem testItem : updated) {
            if (null == testItem.getIssue()) continue;
            Activity.FieldValues fieldValues = results.get(testItem.getId());
            fieldValues.withNewValue(this.issuesIdsToString(testItem.getIssue().getExternalSystemIssues(), separator));
            Activity activity = (Activity)((ActivityBuilder)this.activityBuilder.get()).addProjectRef(event.getProject()).addActionType(ATTACH_ISSUE).addLoggedObjectRef(testItem.getId()).addObjectType("testItem").addUserRef(event.getPostedBy()).addHistory((Map)ImmutableMap.builder().put((Object)TICKET_ID, (Object)fieldValues).build()).build();
            activities.add(activity);
        }
        this.activityRepository.save(activities);
    }

    @EventListener
    public void onIssueTypeDefined(ItemIssueTypeDefined itemIssueTypeDefined) {
        Map data = itemIssueTypeDefined.getBefore();
        List activities = this.processTestItemIssues(itemIssueTypeDefined.getProject(), itemIssueTypeDefined.getPostedBy(), data);
        if (!activities.isEmpty()) {
            this.activityRepository.save((Iterable)activities);
        }
    }

    private String issuesIdsToString(Set<TestItemIssue.ExternalSystemIssue> externalSystemIssues, String separator) {
        if (null != externalSystemIssues && !externalSystemIssues.isEmpty()) {
            return externalSystemIssues.stream().map(externalSystemIssue -> externalSystemIssue.getTicketId().concat(":").concat(externalSystemIssue.getUrl())).collect(Collectors.joining(separator));
        }
        return null;
    }

    private List<Activity> processTestItemIssues(String projectName, String principal, Map<IssueDefinition, TestItem> data) {
        String emptyString = "";
        ArrayList<Activity> activities = new ArrayList<Activity>();
        Project projectSettings = (Project)this.projectSettingsRepository.findOne((Serializable)((Object)projectName));
        Set<Map.Entry<IssueDefinition, TestItem>> entries = data.entrySet();
        for (Map.Entry<IssueDefinition, TestItem> entry : entries) {
            Activity.FieldValues fieldValues;
            String comment;
            IssueDefinition issueDefinition = entry.getKey();
            TestItem testItem = entry.getValue();
            TestItemIssue testItemIssue = testItem.getIssue();
            String oldIssueDescription = testItemIssue.getIssueDescription();
            StatisticSubType statisticSubType = projectSettings.getConfiguration().getByLocator(issueDefinition.getIssue().getIssueType());
            String oldIssueType = projectSettings.getConfiguration().getByLocator(testItemIssue.getIssueType()).getLongName();
            String initialComment = issueDefinition.getIssue().getComment();
            String string = comment = null != initialComment ? initialComment.trim() : emptyString;
            if (null == oldIssueDescription) {
                oldIssueDescription = emptyString;
            }
            Activity activity = (Activity)((ActivityBuilder)this.activityBuilder.get()).addProjectRef(projectName).addLoggedObjectRef(issueDefinition.getId()).addObjectType("testItem").addActionType(UPDATE_ITEM).addUserRef(principal).build();
            HashMap<String, Activity.FieldValues> history = new HashMap<String, Activity.FieldValues>();
            if (!oldIssueDescription.equals(comment)) {
                fieldValues = Activity.FieldValues.newOne().withOldValue(oldIssueDescription).withNewValue(comment);
                history.put(COMMENT, fieldValues);
            }
            if (!(statisticSubType == null || null != oldIssueType && oldIssueType.equalsIgnoreCase(statisticSubType.getLongName()))) {
                fieldValues = Activity.FieldValues.newOne().withOldValue(oldIssueType).withNewValue(statisticSubType.getLongName());
                history.put(ISSUE_TYPE, fieldValues);
            }
            if (history.isEmpty()) continue;
            activity.setHistory(history);
            activities.add(activity);
        }
        return activities;
    }
}

