/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.ws.model.ActivityResource;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ActivityConverter {
    public static final Function<Activity, ActivityResource> TO_RESOURCE = activity -> {
        Preconditions.checkNotNull((Object)activity);
        ActivityResource resource = new ActivityResource();
        resource.setUserRef(activity.getUserRef());
        resource.setProjectRef(activity.getProjectRef());
        resource.setActivityId(activity.getId());
        resource.setLoggedObjectRef(activity.getLoggedObjectRef());
        resource.setLastModifiedDate(activity.getLastModified());
        resource.setObjectType(activity.getObjectType());
        resource.setActionType(activity.getActionType());
        Map<String, ActivityResource.FieldValues> history = Optional.ofNullable(activity.getHistory()).orElseGet(Collections::emptyMap).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (ActivityResource.FieldValues)TO_FIELD_RESOURCE.apply(e.getValue())));
        resource.setHistory(history);
        return resource;
    };
    private static final Function<Activity.FieldValues, ActivityResource.FieldValues> TO_FIELD_RESOURCE = model -> {
        ActivityResource.FieldValues fieldValues = new ActivityResource.FieldValues();
        fieldValues.setOldValue(model.getOldValue());
        fieldValues.setNewValue(model.getNewValue());
        return fieldValues;
    };

    private ActivityConverter() {
    }
}

