/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.item.merge.strategy.DeepMergeStrategy;
import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategy;
import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategyFactory;
import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategyType;
import com.epam.ta.reportportal.core.item.merge.strategy.SuiteMergeStrategy;
import com.epam.ta.reportportal.core.item.merge.strategy.TestMergeStrategy;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MergeStrategyConfig {
    @Autowired
    private TestItemRepository testItemRepository;

    @Bean
    public Map<MergeStrategyType, MergeStrategy> mapping() {
        HashMap<MergeStrategyType, MergeStrategy> mapping = new HashMap<MergeStrategyType, MergeStrategy>();
        mapping.put(MergeStrategyType.TEST, (MergeStrategy)new TestMergeStrategy(this.testItemRepository));
        mapping.put(MergeStrategyType.SUITE, (MergeStrategy)new SuiteMergeStrategy(this.testItemRepository));
        mapping.put(MergeStrategyType.DEEP, (MergeStrategy)new DeepMergeStrategy(this.testItemRepository));
        return mapping;
    }

    @Bean
    public MergeStrategyFactory factory() {
        return new MergeStrategyFactory(this.mapping());
    }
}

