/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.filter.IGetUserFilterHandler;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.util.MoreCollectors;
import com.epam.ta.reportportal.ws.converter.UserFilterResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.filter.UserFilterResource;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetUserFilterHandler
implements IGetUserFilterHandler {
    @Autowired
    private UserFilterRepository filterRepository;
    @Autowired
    private UserFilterResourceAssembler resourceAssembler;

    public UserFilterResource getFilter(String userName, String filterId, String projectName) {
        UserFilter userFilter = (UserFilter)this.filterRepository.findOne((Serializable)((Object)filterId));
        BusinessRule.expect((Object)userFilter, (Predicate)Predicates.notNull()).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterId, userName});
        AclUtils.isPossibleToRead((Acl)userFilter.getAcl(), (String)userName, (String)projectName);
        BusinessRule.expect((Object)userFilter.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        return this.resourceAssembler.toResource(userFilter);
    }

    public List<UserFilterResource> getOwnFilters(String userName, Filter filter, String projectName) {
        List filters = this.filterRepository.findFilters(userName, projectName, Shareable.NAME_OWNER_SORT, false);
        return this.resourceAssembler.toResources((Iterable)filters);
    }

    public List<UserFilterResource> getSharedFilters(String userName, Filter filter, String projectName) {
        List filters = this.filterRepository.findFilters(userName, projectName, Shareable.NAME_OWNER_SORT, true);
        return this.resourceAssembler.toResources((Iterable)filters);
    }

    public Iterable<UserFilterResource> getFilters(String userName, Pageable pageable, Filter filter, String projectName) {
        Page filters = this.filterRepository.findAllByFilter(filter, pageable, projectName, userName);
        return this.resourceAssembler.toPagedResources(filters);
    }

    public Map<String, SharedEntity> getFiltersNames(String userName, String projectName, boolean isShared) {
        List filters = this.filterRepository.findFilters(userName, projectName, Shareable.NAME_OWNER_SORT, isShared);
        return this.getMapOfNames(filters);
    }

    public List<UserFilterResource> getFilters(String projectName, String[] ids, String userName) {
        List filters = this.filterRepository.findAvailableFilters(projectName, ids, userName);
        return this.resourceAssembler.toResources((Iterable)filters);
    }

    private Map<String, SharedEntity> getMapOfNames(List<UserFilter> filters) {
        Map result = Collections.emptyMap();
        if (filters != null) {
            result = (Map)filters.stream().collect(MoreCollectors.toLinkedMap(UserFilter::getId, filter -> {
                SharedEntity entity = new SharedEntity();
                entity.setName(filter.getName());
                if (null != filter.getAcl()) {
                    entity.setOwner(filter.getAcl().getOwnerUserId());
                }
                return entity;
            }));
        }
        return result;
    }
}

