/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.acl.SharingService;
import com.epam.ta.reportportal.core.filter.IUpdateUserFilterHandler;
import com.epam.ta.reportportal.core.filter.impl.UserFilterValidationService;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.entity.filter.ObjectType;
import com.epam.ta.reportportal.database.entity.filter.SelectionOptions;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.events.FilterUpdatedEvent;
import com.epam.ta.reportportal.ws.model.CollectionsRQ;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.filter.BulkUpdateFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.UpdateUserFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.UserFilterEntity;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateUserFilterHandler
implements IUpdateUserFilterHandler {
    @Autowired
    private UserFilterRepository userFilterRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UserFilterValidationService userFilterService;
    @Autowired
    private SharingService sharingService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationCompletionRS updateUserFilter(String userFilterId, UpdateUserFilterRQ updateRQ, String userName, String projectName, UserRole userRole) {
        UserFilter existingFilter = (UserFilter)this.userFilterRepository.findOne((Serializable)((Object)userFilterId));
        BusinessRule.expect((Object)existingFilter, (Predicate)Predicates.notNull()).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{userFilterId, userName});
        AclUtils.isAllowedToEdit((Acl)existingFilter.getAcl(), (String)userName, (Map)this.projectRepository.findProjectRoles(userName), (String)existingFilter.getName(), (UserRole)userRole);
        BusinessRule.expect((Object)existingFilter.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        UserFilter before = (UserFilter)SerializationUtils.clone((Serializable)existingFilter);
        UpdateUserFilterHandler updateUserFilterHandler = this;
        synchronized (updateUserFilterHandler) {
            if (null != updateRQ.getName() && !updateRQ.getName().equals(existingFilter.getName())) {
                this.userFilterService.isFilterNameUnique(userName, updateRQ.getName(), projectName);
            }
            this.updateUserFilter(existingFilter, updateRQ, userName, projectName);
            this.userFilterRepository.save((Object)existingFilter);
            this.eventPublisher.publishEvent((Object)new FilterUpdatedEvent(before, existingFilter, userName));
        }
        return this.buildResponse(existingFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperationCompletionRS> updateUserFilter(CollectionsRQ<BulkUpdateFilterRQ> updateFilterRQs, String userName, String projectName, UserRole userRole) {
        Set idsToLoad = updateFilterRQs.getElements().stream().map(BulkUpdateFilterRQ::getId).collect(Collectors.toSet());
        BusinessRule.expect((Object)idsToLoad.size(), (Predicate)Predicates.equalTo((Object)updateFilterRQs.getElements().size())).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
        UserFilter[] userFilters = (UserFilter[])StreamSupport.stream(this.userFilterRepository.findAll(idsToLoad).spliterator(), false).toArray(UserFilter[]::new);
        BusinessRule.expect((Object)idsToLoad.size(), (Predicate)Predicates.equalTo((Object)userFilters.length)).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[0]);
        List filterFromOtherProjects = Stream.of(userFilters).filter(userFilter -> !userFilter.getProjectName().equalsIgnoreCase(projectName)).collect(Collectors.toList());
        BusinessRule.expect((Object)filterFromOtherProjects.size(), (Predicate)Predicates.equalTo((Object)0)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        Map projectRoles = this.projectRepository.findProjectRoles(userName);
        ArrayList<OperationCompletionRS> result = new ArrayList<OperationCompletionRS>(idsToLoad.size());
        UpdateUserFilterHandler updateUserFilterHandler = this;
        synchronized (updateUserFilterHandler) {
            ArrayList<UserFilter> updatedFilters = new ArrayList<UserFilter>(idsToLoad.size());
            for (int i = 0; i < updateFilterRQs.getElements().size(); ++i) {
                AclUtils.isAllowedToEdit((Acl)userFilters[i].getAcl(), (String)userName, (Map)projectRoles, (String)userFilters[i].getName(), (UserRole)userRole);
                String name = ((BulkUpdateFilterRQ)updateFilterRQs.getElements().get(i)).getName();
                if (null != name && !name.equals(userFilters[i].getName())) {
                    this.userFilterService.isFilterNameUnique(userName, ((BulkUpdateFilterRQ)updateFilterRQs.getElements().get(i)).getName(), projectName);
                }
                this.updateUserFilter(userFilters[i], (UpdateUserFilterRQ)updateFilterRQs.getElements().get(i), userName, projectName);
                updatedFilters.add(userFilters[i]);
                result.add(this.buildResponse(userFilters[i]));
            }
            this.userFilterRepository.save(updatedFilters);
        }
        return result;
    }

    private void updateUserFilter(UserFilter toUpdate, UpdateUserFilterRQ updateRQ, String userName, String projectName) {
        if (null != updateRQ.getName()) {
            toUpdate.setName(updateRQ.getName().trim());
        }
        if (null != updateRQ.getEntities()) {
            toUpdate.setFilter(this.createFilter(updateRQ.getObjectType(), updateRQ.getEntities()));
        }
        toUpdate.setDescription(updateRQ.getDescription());
        toUpdate.setIsLink(updateRQ.getIsLink());
        if (null != updateRQ.getSelectionParameters()) {
            this.userFilterService.validateSortingColumnName(toUpdate.getFilter().getTarget(), updateRQ.getSelectionParameters().getSortingColumnName());
            SelectionOptions selectionOptions = new SelectionOptions();
            selectionOptions.setSortingColumnName(updateRQ.getSelectionParameters().getSortingColumnName());
            selectionOptions.setIsAsc(updateRQ.getSelectionParameters().getIsAsc());
            selectionOptions.setPageNumber(updateRQ.getSelectionParameters().getPageNumber());
            toUpdate.setSelectionOptions(selectionOptions);
        }
        if (null != updateRQ.getShare()) {
            this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new UserFilter[]{toUpdate}), userName, projectName, updateRQ.getShare().booleanValue());
        }
    }

    private Filter createFilter(String objectType, Set<UserFilterEntity> entities) {
        LinkedHashSet<FilterCondition> filterConditions = new LinkedHashSet<FilterCondition>(entities.size());
        for (UserFilterEntity filterEntity : entities) {
            Condition conditionObject = Condition.findByMarker((String)filterEntity.getCondition()).orElse(null);
            FilterCondition filterCondition = new FilterCondition(conditionObject, Condition.isNegative((String)filterEntity.getCondition()), filterEntity.getValue().trim(), filterEntity.getFilteringField().trim());
            filterConditions.add(filterCondition);
        }
        return new Filter(ObjectType.getTypeByName((String)objectType), filterConditions);
    }

    private OperationCompletionRS buildResponse(UserFilter existingFilter) {
        return new OperationCompletionRS("User filter with ID = '" + existingFilter.getId() + "' successfully updated.");
    }
}

