/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl.junit;

import com.epam.ta.reportportal.core.imprt.impl.DateUtils;
import com.epam.ta.reportportal.core.imprt.impl.junit.XunitImportHandler;
import com.epam.ta.reportportal.core.imprt.impl.junit.XunitReportTag;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.log.ICreateLogHandler;
import com.epam.ta.reportportal.database.entity.LogLevel;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XunitImportHandler
extends DefaultHandler {
    @Autowired
    private StartTestItemHandler startTestItemHandler;
    @Autowired
    private FinishTestItemHandler finishTestItemHandler;
    @Autowired
    private ICreateLogHandler createLogHandler;
    private String projectId;
    private String userName;
    private String launchId;
    private String currentId;
    private LocalDateTime startSuiteTime;
    private long commonDuration;
    private long currentDuration;
    private Deque<String> itemsIds;
    private Status status;
    private StringBuilder message;
    private LocalDateTime startItemTime;

    @Override
    public void startDocument() throws SAXException {
        this.itemsIds = new ArrayDeque();
        this.message = new StringBuilder();
        this.startSuiteTime = LocalDateTime.now();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (1.$SwitchMap$com$epam$ta$reportportal$core$imprt$impl$junit$XunitReportTag[XunitReportTag.fromString((String)qName).ordinal()]) {
            case 1: {
                this.startRootItem(attributes.getValue(XunitReportTag.ATTR_NAME.getValue()), attributes.getValue(XunitReportTag.TIMESTAMP.getValue()));
                break;
            }
            case 2: {
                this.startTestItem(attributes.getValue(XunitReportTag.ATTR_NAME.getValue()), attributes.getValue(XunitReportTag.ATTR_TIME.getValue()));
                break;
            }
            case 3: 
            case 4: {
                this.message = new StringBuilder();
                this.status = Status.FAILED;
                break;
            }
            case 5: {
                this.message = new StringBuilder();
                this.status = Status.SKIPPED;
                break;
            }
            case 6: 
            case 7: {
                this.message = new StringBuilder();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (1.$SwitchMap$com$epam$ta$reportportal$core$imprt$impl$junit$XunitReportTag[XunitReportTag.fromString((String)qName).ordinal()]) {
            case 1: {
                this.finishRootItem();
                break;
            }
            case 2: {
                this.finishTestItem();
                break;
            }
            case 5: {
                this.attachLog(LogLevel.ERROR);
                break;
            }
            case 3: 
            case 4: {
                this.attachLog(LogLevel.ERROR);
                break;
            }
            case 6: 
            case 7: {
                this.attachDebugLog(LogLevel.DEBUG);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String msg = new String(ch, start, length);
        if (!msg.isEmpty()) {
            this.message.append(new String(ch, start, length));
        }
    }

    private void startRootItem(String name, String timestamp) {
        if (null != timestamp) {
            this.startItemTime = this.parseTimeStamp(timestamp);
            if (this.startSuiteTime.isAfter(this.startItemTime)) {
                this.startSuiteTime = LocalDateTime.of(this.startItemTime.toLocalDate(), this.startItemTime.toLocalTime());
            }
        } else {
            this.startItemTime = LocalDateTime.now();
        }
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setLaunchId(this.launchId);
        rq.setStartTime(DateUtils.toDate((LocalDateTime)this.startItemTime));
        rq.setType(TestItemType.TEST.name());
        rq.setName(name);
        String id = this.startTestItemHandler.startRootItem(this.projectId, rq).getId();
        this.itemsIds.push(id);
    }

    private LocalDateTime parseTimeStamp(String timestamp) {
        LocalDateTime localDateTime = null;
        try {
            localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(timestamp)), ZoneId.systemDefault());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (null == localDateTime) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.RFC_1123_DATE_TIME).appendOptional(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendZoneId().optionalEnd().toFormatter();
            localDateTime = LocalDateTime.parse(timestamp, formatter);
        }
        return localDateTime;
    }

    private void startTestItem(String name, String duration) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setLaunchId(this.launchId);
        rq.setStartTime(DateUtils.toDate((LocalDateTime)this.startItemTime));
        rq.setType(TestItemType.STEP.name());
        rq.setName(name);
        String id = this.startTestItemHandler.startChildItem(this.projectId, rq, (String)this.itemsIds.peekLast()).getId();
        this.currentDuration = DateUtils.toMillis((String)duration);
        this.currentId = id;
        this.itemsIds.push(id);
    }

    private void finishRootItem() {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(DateUtils.toDate((LocalDateTime)this.startItemTime));
        rq.setStatus(Optional.ofNullable(this.status).orElse(Status.PASSED).name());
        this.finishTestItemHandler.finishTestItem((String)this.itemsIds.poll(), rq, this.userName);
        this.status = null;
    }

    private void finishTestItem() {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        this.startItemTime = this.startItemTime.plus(this.currentDuration, ChronoUnit.MILLIS);
        this.commonDuration += this.currentDuration;
        rq.setEndTime(DateUtils.toDate((LocalDateTime)this.startItemTime));
        rq.setStatus(Optional.ofNullable(this.status).orElse(Status.PASSED).name());
        this.currentId = (String)this.itemsIds.poll();
        this.finishTestItemHandler.finishTestItem(this.currentId, rq, this.userName);
        this.status = null;
    }

    private void attachDebugLog(LogLevel logLevel) {
        if (null != this.message && this.message.length() != 0) {
            SaveLogRQ saveLogRQ = new SaveLogRQ();
            saveLogRQ.setLevel(logLevel.name());
            saveLogRQ.setLogTime(DateUtils.toDate((LocalDateTime)this.startItemTime));
            saveLogRQ.setMessage(this.message.toString().trim());
            saveLogRQ.setTestItemId(this.currentId);
            this.createLogHandler.createLog(saveLogRQ, null, this.projectId);
        }
    }

    private void attachLog(LogLevel logLevel) {
        if (null != this.message && this.message.length() != 0) {
            SaveLogRQ saveLogRQ = new SaveLogRQ();
            saveLogRQ.setLevel(logLevel.name());
            saveLogRQ.setLogTime(DateUtils.toDate((LocalDateTime)this.startItemTime));
            saveLogRQ.setMessage(this.message.toString().trim());
            saveLogRQ.setTestItemId((String)this.itemsIds.getFirst());
            this.createLogHandler.createLog(saveLogRQ, null, this.projectId);
        }
    }

    XunitImportHandler withParameters(String projectId, String launchId, String user) {
        this.projectId = projectId;
        this.launchId = launchId;
        this.userName = user;
        return this;
    }

    LocalDateTime getStartSuiteTime() {
        return this.startSuiteTime;
    }

    long getCommonDuration() {
        return this.commonDuration;
    }
}

