/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.DeleteTestItemHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsFacade;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class DeleteTestItemHandlerImpl
implements DeleteTestItemHandler {
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UserRepository userRepository;

    DeleteTestItemHandlerImpl() {
    }

    public OperationCompletionRS deleteTestItem(String itemId, String projectName, String username) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{project});
        User user = (User)this.userRepository.findOne((Serializable)((Object)username));
        BusinessRule.expect((Object)user, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{username});
        TestItem item = (TestItem)this.testItemRepository.findOne((Serializable)((Object)itemId));
        this.validate(itemId, item, projectName);
        this.validateRoles(item, user, project);
        try {
            StatisticsFacade statisticsFacade = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy());
            statisticsFacade.deleteExecutionStatistics(item);
            if (!item.getStatistics().getIssueCounter().isEmpty()) {
                statisticsFacade.deleteIssueStatistics(item);
            }
            this.testItemRepository.delete((Serializable)((Object)itemId));
            if (null != item.getParent()) {
                TestItem parent = (TestItem)this.testItemRepository.findOne((Serializable)((Object)item.getParent()));
                if (!this.testItemRepository.findAllDescendants(parent.getId()).isEmpty()) {
                    statisticsFacade.updateParentStatusFromStatistics(parent);
                } else {
                    parent.setHasChilds(false);
                    parent.setStatus(Status.RESETED);
                    this.testItemRepository.save((Object)parent);
                }
            }
            Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)item.getLaunchRef()));
            if (Predicates.not((Predicate)Preconditions.IN_PROGRESS).test(launch)) {
                statisticsFacade.updateLaunchFromStatistics(launch);
            }
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during deleting TestStep item", (Throwable)e);
        }
        return new OperationCompletionRS("Test Item with ID = '" + itemId + "' has been successfully deleted.");
    }

    public List<OperationCompletionRS> deleteTestItem(String[] ids, String project, String user) {
        return Stream.of(ids).map(it -> this.deleteTestItem(it, project, user)).collect(Collectors.toList());
    }

    private void validate(String testItemId, TestItem testItem, String projectName) {
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId});
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.not((Predicate)Preconditions.IN_PROGRESS)).verify(ErrorType.TEST_ITEM_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] in progress state", (Object[])new Object[]{testItem.getId()})});
        Launch parentLaunch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        BusinessRule.expect((Object)parentLaunch, (Predicate)Predicates.not((Predicate)Preconditions.IN_PROGRESS)).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] under launch ['{}'] with 'In progress' state", (Object[])new Object[]{testItem.getId(), testItem.getLaunchRef()})});
        BusinessRule.expect((Object)projectName, (Predicate)Predicates.equalTo((Object)parentLaunch.getProjectRef())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Deleting testItem '{}' is not under specified project '{}'", (Object[])new Object[]{testItem.getId(), projectName})});
    }

    private void validateRoles(TestItem testItem, User user, Project project) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        if (user.getRole() != UserRole.ADMINISTRATOR && !user.getId().equalsIgnoreCase(launch.getUserRef())) {
            Project.UserConfig userConfig = ProjectUtils.findUserConfigByLogin((Project)project, (String)user.getId());
            BusinessRule.expect((Object)userConfig, (Predicate)Preconditions.hasProjectRoles(Collections.singletonList(ProjectRole.PROJECT_MANAGER))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }
}

