/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.item.UniqueIdGenerator;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.ws.converter.builders.TestItemBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import java.io.Serializable;
import java.util.Date;
import java.util.function.Predicate;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class StartTestItemHandlerImpl
implements StartTestItemHandler {
    private TestItemRepository testItemRepository;
    private LaunchRepository launchRepository;
    private Provider<TestItemBuilder> testItemBuilder;
    private UniqueIdGenerator identifierGenerator;

    StartTestItemHandlerImpl() {
    }

    @Autowired
    public void setIdentifierGenerator(UniqueIdGenerator identifierGenerator) {
        this.identifierGenerator = identifierGenerator;
    }

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    @Autowired
    public void setTestItemBuilder(Provider<TestItemBuilder> testItemBuilder) {
        this.testItemBuilder = testItemBuilder;
    }

    public EntryCreatedRS startRootItem(String projectName, StartTestItemRQ rq) {
        Launch launch = this.launchRepository.loadStatusProjectRefAndStartTime(rq.getLaunchId());
        this.validate(projectName, rq, launch);
        TestItem item = (TestItem)((TestItemBuilder)this.testItemBuilder.get()).addStartItemRequest(rq).addStatus(Status.IN_PROGRESS).addLaunch(launch).build();
        if (null == item.getUniqueId()) {
            item.setUniqueId(this.identifierGenerator.generate(item));
        }
        this.testItemRepository.save((Object)item);
        return new EntryCreatedRS(item.getId());
    }

    public EntryCreatedRS startChildItem(String projectName, StartTestItemRQ rq, String parent) {
        TestItem parentItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)parent));
        this.validate(parentItem, parent);
        this.validate(rq, parentItem);
        TestItem item = (TestItem)((TestItemBuilder)this.testItemBuilder.get()).addStartItemRequest(rq).addParent(parentItem).addPath(parentItem).addStatus(Status.IN_PROGRESS).build();
        if (null == item.getUniqueId()) {
            item.setUniqueId(this.identifierGenerator.generate(item));
        }
        this.testItemRepository.save((Object)item);
        if (!parentItem.hasChilds()) {
            this.testItemRepository.updateHasChilds(parentItem.getId(), true);
        }
        return new EntryCreatedRS(item.getId());
    }

    private void validate(String projectName, StartTestItemRQ rq, Launch launch) {
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{rq.getLaunchId()});
        BusinessRule.expect((Object)projectName.toLowerCase(), (Predicate)Predicates.equalTo((Object)launch.getProjectRef())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        BusinessRule.expect((Object)launch, (Predicate)Preconditions.IN_PROGRESS).verify(ErrorType.START_ITEM_NOT_ALLOWED, new Object[]{Suppliers.formattedSupplier((String)"Launch '{}' is not in progress", (Object[])new Object[]{rq.getLaunchId()})});
        BusinessRule.expect((Object)rq, (Predicate)Preconditions.startSameTimeOrLater((Date)launch.getStartTime())).verify(ErrorType.CHILD_START_TIME_EARLIER_THAN_PARENT, new Object[]{rq.getStartTime(), launch.getStartTime(), launch.getId()});
    }

    private void validate(TestItem parentTestItem, String parent) {
        BusinessRule.expect((Object)parentTestItem, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parent});
        BusinessRule.expect((Object)parentTestItem, (Predicate)Preconditions.IN_PROGRESS).verify(ErrorType.START_ITEM_NOT_ALLOWED, new Object[]{Suppliers.formattedSupplier((String)"Parent Item '{}' is not in progress", (Object[])new Object[]{parentTestItem.getId()})});
    }

    private void validate(StartTestItemRQ rq, TestItem parent) {
        BusinessRule.expect((Object)rq, (Predicate)Preconditions.startSameTimeOrLater((Date)parent.getStartTime())).verify(ErrorType.CHILD_START_TIME_EARLIER_THAN_PARENT, new Object[]{rq.getStartTime(), parent.getStartTime(), parent.getId()});
    }
}

