/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.launch.IUpdateLaunchHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.launch.AutoAnalyzeStrategy;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.util.analyzer.AnalyzerConfig;
import com.epam.ta.reportportal.util.analyzer.IIssuesAnalyzer;
import com.epam.ta.reportportal.ws.model.BulkRQ;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.launch.UpdateLaunchRQ;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class UpdateLaunchHandler
implements IUpdateLaunchHandler {
    @Autowired
    private TestItemRepository testItemRepository;
    private ProjectRepository projectRepository;
    private LaunchRepository launchRepository;
    private UserRepository userRepository;
    @Autowired
    private IIssuesAnalyzer analyzerService;
    @Autowired
    @Qualifier(value="autoAnalyzeTaskExecutor")
    private TaskExecutor taskExecutor;
    @Autowired
    private AnalyzerConfig analyzerConfig;

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    @Autowired
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public OperationCompletionRS updateLaunch(String launchId, String projectName, String userName, UpdateLaunchRQ rq) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        this.validate(launch, userName, projectName, rq.getMode());
        if (null != rq.getMode() || null != rq.getDescription() || null != rq.getTags()) {
            if (null != rq.getMode()) {
                launch.setMode(rq.getMode());
            }
            if (null != rq.getDescription()) {
                launch.setDescription(rq.getDescription().trim());
            }
            if (null != rq.getTags()) {
                launch.setTags((Set)Sets.newHashSet((Iterable)EntityUtils.trimStrings((Iterable)EntityUtils.update((Iterable)rq.getTags()))));
            }
            this.launchRepository.save((Object)launch);
        }
        return new OperationCompletionRS("Launch with ID = '" + launch.getId() + "' successfully updated.");
    }

    public OperationCompletionRS startLaunchAnalyzer(String projectName, String launchId, String scope) {
        AutoAnalyzeStrategy type = AutoAnalyzeStrategy.fromValue((String)scope);
        BusinessRule.expect((Object)type, (Predicate)Predicates.notNull()).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{scope});
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch with ID '{}' is not under '{}' project.", (Object[])new Object[]{launchId, projectName})});
        BusinessRule.expect((Object)launch.getMode(), (Predicate)Predicates.equalTo((Object)Mode.DEFAULT)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Cannot analyze launches in debug mode."});
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        if (!this.analyzerService.isPossible(launchId) && type.equals((Object)AutoAnalyzeStrategy.HISTORY)) {
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch with ID '{}' in auto-analyzer cache already", (Object[])new Object[]{launchId})});
        }
        if (!(!launch.getStatus().equals((Object)Status.IN_PROGRESS) && this.analyzerService.isPossible(launchId) || type.equals((Object)AutoAnalyzeStrategy.HISTORY))) {
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch with ID '{}' in auto-analyzer cache already and/or in progress still", (Object[])new Object[]{launchId})});
        }
        List toInvestigate = this.testItemRepository.findInIssueTypeItems(TestItemIssueType.TO_INVESTIGATE.getLocator(), launchId);
        List got = type.equals((Object)AutoAnalyzeStrategy.SINGLE) ? this.analyzerService.collectPreviousIssues(1, launchId, projectName) : this.analyzerService.collectPreviousIssues(this.analyzerConfig.getDepth(), launchId, projectName);
        if (this.analyzerService.analyzeStarted(launchId)) {
            this.taskExecutor.execute(() -> this.analyzerService.analyze(launchId, toInvestigate, got));
        }
        return new OperationCompletionRS("Auto-analyzer for launch ID='" + launchId + "' started.");
    }

    public List<OperationCompletionRS> updateLaunch(BulkRQ<UpdateLaunchRQ> rq, String projectName, String userName) {
        return rq.getEntities().entrySet().stream().map(entry -> this.updateLaunch((String)entry.getKey(), projectName, userName, (UpdateLaunchRQ)entry.getValue())).collect(Collectors.toList());
    }

    private void validate(Launch launch, String userName, String projectName, Mode mode) {
        String launchOwner = launch.getUserRef();
        User principal = (User)this.userRepository.findOne((Serializable)((Object)userName));
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        if (ProjectUtils.findUserConfigByLogin((Project)project, (String)userName).getProjectRole() == ProjectRole.CUSTOMER && null != mode) {
            BusinessRule.expect((Object)mode, (Predicate)Predicates.equalTo((Object)Mode.DEFAULT)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        if (principal.getRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            if (null == launchOwner || !launchOwner.equalsIgnoreCase(userName)) {
                Project.UserConfig userConfig = ProjectUtils.findUserConfigByLogin((Project)project, (String)userName);
                BusinessRule.expect((Object)userConfig, (Predicate)Preconditions.hasProjectRoles(Collections.singletonList(ProjectRole.PROJECT_MANAGER))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            } else {
                BusinessRule.expect((Object)userName, (Predicate)Predicates.equalTo((Object)launchOwner)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            }
        }
    }
}

