/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.database.OverallStatisticsDocumentHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.stereotype.Service;

@Service(value="OverallStatisticsContentLoader")
public class OverallStatisticsContentLoader
extends StatisticBasedContentLoader
implements IContentLoadingStrategy {
    @Autowired
    private LaunchRepository launchRepository;
    private static final String COLLECTION_NAME = "launch";

    public Map<String, List<ChartObject>> loadContent(String projectName, Filter filter, Sort sorting, int quantity, List<String> contentFields, List<String> metaDataFields, Map<String, List<String>> options) {
        OverallStatisticsDocumentHandler overallStatisticsContentLoader = new OverallStatisticsDocumentHandler(contentFields);
        if (options.containsKey("latest")) {
            this.launchRepository.findLatestWithCallback((Queryable)filter, sorting, contentFields, (long)quantity, (DocumentCallbackHandler)overallStatisticsContentLoader);
        } else {
            this.launchRepository.loadWithCallback((Queryable)filter, sorting, quantity, contentFields, (DocumentCallbackHandler)overallStatisticsContentLoader, COLLECTION_NAME);
        }
        return this.assembleData(overallStatisticsContentLoader.getResult());
    }

    private Map<String, List<ChartObject>> assembleData(Map<String, Integer> data) {
        Map<String, String> values = data.keySet().stream().collect(Collectors.toMap(arg_0 -> this.getFieldName(arg_0), key -> ((Integer)data.get(key)).toString()));
        ChartObject chartObject = new ChartObject();
        chartObject.setValues(values);
        return Collections.singletonMap("result", Collections.singletonList(chartObject));
    }

    private String getFieldName(String fieldName) {
        String[] split = fieldName.split("\\.");
        return split[split.length - 1];
    }
}

