/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.acl.SharingService;
import com.epam.ta.reportportal.core.widget.ICreateWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.content.WidgetDataTypes;
import com.epam.ta.reportportal.core.widget.impl.WidgetUtils;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.events.WidgetCreatedEvent;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ContentParameters;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class CreateWidgetHandler
implements ICreateWidgetHandler {
    private WidgetRepository widgetRepository;
    private Provider<WidgetBuilder> widgetBuilder;
    private UserFilterRepository filterRepository;
    private CriteriaMapFactory criteriaMapFactory;
    private SharingService sharingService;
    private ApplicationEventPublisher eventPublisher;

    @Autowired
    public void setWidgetRepository(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Autowired
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Autowired
    public void setWidgetBuilder(Provider<WidgetBuilder> widgetBuilder) {
        this.widgetBuilder = widgetBuilder;
    }

    @Autowired
    public void setUserFilterRepository(UserFilterRepository userFilterRepository) {
        this.filterRepository = userFilterRepository;
    }

    @Autowired
    public void setCriteriaMapFactory(CriteriaMapFactory criteriaMapFactory) {
        this.criteriaMapFactory = criteriaMapFactory;
    }

    @Autowired
    public void setSharingService(SharingService sharingService) {
        this.sharingService = sharingService;
    }

    public EntryCreatedRS createWidget(WidgetRQ createWidgetRQ, String projectName, String userName) {
        List widgetList = this.widgetRepository.findByProjectAndUser(projectName, userName);
        WidgetUtils.checkUniqueName((String)createWidgetRQ.getName(), (List)widgetList);
        String widgetType = createWidgetRQ.getContentParameters().getType();
        WidgetUtils.validateWidgetDataType((String)widgetType, (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        WidgetUtils.validateGadgetType((String)createWidgetRQ.getContentParameters().getGadget(), (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        Widget widget = !widgetType.equals(WidgetDataTypes.CLEAN_WIDGET.getType()) ? this.create(createWidgetRQ, projectName, userName) : this.createWithoutFilter(createWidgetRQ, projectName, userName);
        this.widgetRepository.save((Object)widget);
        this.eventPublisher.publishEvent((Object)new WidgetCreatedEvent(createWidgetRQ, userName, projectName, widget.getId()));
        return new EntryCreatedRS(widget.getId());
    }

    private Widget create(WidgetRQ createWidgetRQ, String projectName, String userName) {
        UserFilter filter = this.filterRepository.findOneLoadACL(userName, createWidgetRQ.getFilterId(), projectName);
        GadgetTypes gadget = (GadgetTypes)GadgetTypes.findByName((String)createWidgetRQ.getContentParameters().getGadget()).get();
        if (gadget != GadgetTypes.ACTIVITY && gadget != GadgetTypes.MOST_FAILED_TEST_CASES && gadget != GadgetTypes.PASSING_RATE_PER_LAUNCH) {
            this.checkApplyingFilter(filter, createWidgetRQ.getFilterId(), userName);
        }
        this.clearContentParameters(createWidgetRQ.getContentParameters(), filter);
        this.validateContentParameters(createWidgetRQ.getContentParameters(), filter, gadget);
        Widget widget = (Widget)((WidgetBuilder)this.widgetBuilder.get()).addWidgetRQ(createWidgetRQ).addFilter(createWidgetRQ.getFilterId()).addProject(projectName).addSharing(userName, projectName, createWidgetRQ.getDescription(), createWidgetRQ.getShare() == null ? false : createWidgetRQ.getShare()).build();
        this.shareIfRequired(createWidgetRQ.getShare(), widget, userName, projectName, filter);
        return widget;
    }

    private Widget createWithoutFilter(WidgetRQ createWidgetRq, String project, String user) {
        Widget widget = (Widget)((WidgetBuilder)this.widgetBuilder.get()).addWidgetRQ(createWidgetRq).addProject(project).addSharing(user, project, createWidgetRq.getDescription(), createWidgetRq.getShare() == null ? false : createWidgetRq.getShare()).build();
        this.shareIfRequired(createWidgetRq.getShare(), widget, user, project, null);
        this.widgetRepository.save((Object)widget);
        return widget;
    }

    private void shareIfRequired(Boolean isShare, Widget widget, String userName, String projectName, UserFilter filter) {
        if (isShare != null) {
            if (null != filter) {
                AclUtils.isPossibleToRead((Acl)filter.getAcl(), (String)userName, (String)projectName);
            }
            this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new Widget[]{widget}), userName, projectName, isShare.booleanValue());
        }
    }

    private void clearContentParameters(ContentParameters contentParameters, UserFilter filter) {
        if (null != contentParameters.getMetadataFields() && (null == filter || filter.getFilter().getTarget().equals(TestItem.class)) && contentParameters.getMetadataFields().contains("number")) {
            contentParameters.getMetadataFields().remove("number");
        }
        if (null != contentParameters.getContentFields() && (null == filter || filter.getFilter().getTarget().equals(TestItem.class))) {
            if (contentParameters.getContentFields().contains("number")) {
                contentParameters.getContentFields().remove("number");
            }
            if (contentParameters.getContentFields().contains("user")) {
                contentParameters.getContentFields().remove("user");
            }
        }
    }

    private void validateContentParameters(ContentParameters contentParameters, UserFilter filter, GadgetTypes gadget) {
        Class filterTarget = gadget == GadgetTypes.UNIQUE_BUG_TABLE ? TestItem.class : (gadget == GadgetTypes.ACTIVITY ? Activity.class : (gadget == GadgetTypes.MOST_FAILED_TEST_CASES ? TestItem.class : (gadget == GadgetTypes.PASSING_RATE_PER_LAUNCH ? Launch.class : filter.getFilter().getTarget())));
        CriteriaMap criteriaMap = this.criteriaMapFactory.getCriteriaMap(filterTarget);
        if (null != contentParameters.getContentFields()) {
            WidgetUtils.validateFields((Iterable)contentParameters.getContentFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        }
        if (null != contentParameters.getMetadataFields()) {
            WidgetUtils.validateFields((Iterable)contentParameters.getMetadataFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        }
    }

    private void checkApplyingFilter(UserFilter filter, String filterID, String userName) {
        BusinessRule.expect((Object)filter, (Predicate)Predicates.notNull()).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterID, userName});
        BusinessRule.expect((Object)filter.isLink(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.UNABLE_TO_CREATE_WIDGET, new Object[]{"Cannot create widget based on a link."});
    }
}

