/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.events.ImportFinishedEvent;
import com.epam.ta.reportportal.events.ImportStartedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ImportActivityHandler {
    @Autowired
    private ActivityRepository activityRepository;

    @EventListener
    public void onImportStart(ImportStartedEvent event) {
        Activity activity = new ActivityBuilder().addObjectName(event.getFileName()).addObjectType(ActivityObjectType.LAUNCH).addActionType(ActivityEventType.START_IMPORT).addUserRef(event.getUserName()).addProjectRef(event.getProjectId()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)"", (String)event.getFileName()))).get();
        this.activityRepository.save((Object)activity);
    }

    @EventListener
    public void onImportFinish(ImportFinishedEvent event) {
        Activity activity = new ActivityBuilder().addObjectName(event.getFileName()).addObjectType(ActivityObjectType.LAUNCH).addActionType(ActivityEventType.FINISH_IMPORT).addUserRef(event.getUserName()).addProjectRef(event.getProjectId()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)"", (String)event.getFileName()))).get();
        this.activityRepository.save((Object)activity);
    }
}

