/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.commons.SendCase;
import com.epam.ta.reportportal.database.dao.FailReferenceResourceRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.FailReferenceResource;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.project.email.EmailSenderCase;
import com.epam.ta.reportportal.database.entity.project.email.ProjectEmailConfig;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.events.LaunchFinishedEvent;
import com.epam.ta.reportportal.events.handler.LaunchFinishedEventHandler;
import com.epam.ta.reportportal.util.analyzer.AnalyzerConfig;
import com.epam.ta.reportportal.util.analyzer.IIssuesAnalyzer;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class LaunchFinishedEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaunchFinishedEventHandler.class);
    private final FailReferenceResourceRepository issuesRepository;
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final IIssuesAnalyzer analyzerService;
    private final MailServiceFactory emailServiceFactory;
    private final UserRepository userRepository;
    private final Provider<HttpServletRequest> currentRequest;
    private final Integer autoAnalysisDepth;

    @Autowired
    public LaunchFinishedEventHandler(IIssuesAnalyzer analyzerService, UserRepository userRepository, TestItemRepository testItemRepository, Provider<HttpServletRequest> currentRequest, LaunchRepository launchRepository, MailServiceFactory emailServiceFactory, FailReferenceResourceRepository issuesRepository, AnalyzerConfig analyzerConfig) {
        this.analyzerService = analyzerService;
        this.userRepository = userRepository;
        this.testItemRepository = testItemRepository;
        this.currentRequest = currentRequest;
        this.launchRepository = launchRepository;
        this.emailServiceFactory = emailServiceFactory;
        this.issuesRepository = issuesRepository;
        this.autoAnalysisDepth = analyzerConfig.getDepth();
    }

    @EventListener
    public void onApplicationEvent(LaunchFinishedEvent event) {
        this.afterFinishLaunch(event.getProject(), event.getLaunch());
    }

    private void afterFinishLaunch(Project project, Launch launch) {
        if (null == project || null == launch) {
            return;
        }
        Optional emailService = this.emailServiceFactory.getDefaultEmailService(project.getConfiguration().getEmailConfig());
        boolean waitForAutoAnalysis = BooleanUtils.toBoolean((Boolean)project.getConfiguration().getIsAutoAnalyzerEnabled());
        if (!waitForAutoAnalysis) {
            emailService.ifPresent(service -> this.sendEmailRightNow(launch, project, service));
        }
        if (launch.getMode().equals((Object)Mode.DEBUG)) {
            return;
        }
        List resources = this.issuesRepository.findAllLaunchIssues(launch.getId());
        if (!project.getConfiguration().getIsAutoAnalyzerEnabled().booleanValue()) {
            this.clearInvestigatedIssues(resources);
            return;
        }
        List previous = this.analyzerService.collectPreviousIssues(this.autoAnalysisDepth.intValue(), launch.getId(), project.getName());
        List converted = resources.stream().map(resource -> (TestItem)this.testItemRepository.findOne((Serializable)((Object)resource.getTestItemRef()))).collect(Collectors.toList());
        this.analyzerService.analyze(launch.getId(), converted, previous);
        this.clearInvestigatedIssues(resources);
        if (waitForAutoAnalysis) {
            Launch freshLaunch = (Launch)this.launchRepository.findOne((Serializable)((Object)launch.getId()));
            emailService.ifPresent(it -> this.sendEmailRightNow(freshLaunch, project, it));
        }
    }

    private void clearInvestigatedIssues(List<FailReferenceResource> issues) {
        this.issuesRepository.delete(issues);
    }

    private static double getSuccessRate(Launch launch) {
        Double ti = launch.getStatistics().getIssueCounter().getToInvestigateTotal().doubleValue();
        Double pb = launch.getStatistics().getIssueCounter().getProductBugTotal().doubleValue();
        Double si = launch.getStatistics().getIssueCounter().getSystemIssueTotal().doubleValue();
        Double ab = launch.getStatistics().getIssueCounter().getAutomationBugTotal().doubleValue();
        Double total = launch.getStatistics().getExecutionCounter().getTotal().doubleValue();
        return total == 0.0 ? total : (ti + pb + si + ab) / total;
    }

    static boolean isSuccessRateEnough(Launch launch, SendCase option) {
        switch (1.$SwitchMap$com$epam$ta$reportportal$commons$SendCase[option.ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return launch.getStatus().equals((Object)Status.FAILED);
            }
            case 3: {
                return launch.getStatistics().getIssueCounter().getToInvestigateTotal() > 0;
            }
            case 4: {
                return LaunchFinishedEventHandler.getSuccessRate((Launch)launch) > 0.1;
            }
            case 5: {
                return LaunchFinishedEventHandler.getSuccessRate((Launch)launch) > 0.2;
            }
            case 6: {
                return LaunchFinishedEventHandler.getSuccessRate((Launch)launch) > 0.5;
            }
        }
        return false;
    }

    static boolean isLaunchNameMatched(Launch launch, EmailSenderCase oneCase) {
        List configuredNames = oneCase.getLaunchNames();
        return null == configuredNames || configuredNames.isEmpty() || configuredNames.contains(launch.getName());
    }

    @VisibleForTesting
    static boolean isTagsMatched(Launch launch, EmailSenderCase oneCase) {
        return null == oneCase.getTags() || oneCase.getTags().isEmpty() || null != launch.getTags() && launch.getTags().containsAll(oneCase.getTags());
    }

    void sendEmailRightNow(Launch launch, Project project, EmailService emailService) {
        ProjectEmailConfig projectConfig = project.getConfiguration().getEmailConfig();
        for (EmailSenderCase one : projectConfig.getEmailCases()) {
            Optional option = SendCase.findByName((String)one.getSendCase());
            boolean successRate = LaunchFinishedEventHandler.isSuccessRateEnough((Launch)launch, (SendCase)((SendCase)option.get()));
            boolean matchedNames = LaunchFinishedEventHandler.isLaunchNameMatched((Launch)launch, (EmailSenderCase)one);
            boolean matchedTags = LaunchFinishedEventHandler.isTagsMatched((Launch)launch, (EmailSenderCase)one);
            List recipients = one.getRecipients();
            if (!successRate || !matchedNames || !matchedTags) continue;
            String[] recipientsArray = this.findRecipients(launch.getUserRef(), recipients);
            try {
                String basicURL = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest((HttpServletRequest)this.currentRequest.get())).replacePath(String.format("/#%s/launches/all/", project.getName())).build().toUriString();
                emailService.sendLaunchFinishNotification(recipientsArray, basicURL + launch.getId(), launch, project.getConfiguration());
            }
            catch (Exception e) {
                LOGGER.error("Unable to send email. Error: \n{}", (Throwable)e);
            }
        }
    }

    String[] findRecipients(String owner, List<String> recipients) {
        return (String[])recipients.stream().map(recipient -> {
            if (recipient.contains("@")) {
                return recipient;
            }
            String toFind = recipient.equals(ProjectUtils.getOwner()) ? owner : recipient;
            User user = (User)this.userRepository.findOne((Serializable)((Object)toFind));
            if (user != null) {
                return user.getEmail();
            }
            return null;
        }).filter(Objects::nonNull).distinct().toArray(String[]::new);
    }
}

