/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.events.ProjectUpdatedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.project.ProjectConfiguration;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ProjectActivityHandler {
    public static final String KEEP_SCREENSHOTS = "keepScreenshots";
    public static final String KEEP_LOGS = "keepLogs";
    public static final String LAUNCH_INACTIVITY = "launchInactivity";
    public static final String STATISTICS_CALCULATION_STRATEGY = "statisticsCalculationStrategy";
    public static final String AUTO_ANALYZE = "auto_analyze";
    private final ActivityRepository activityRepository;

    @Autowired
    public ProjectActivityHandler(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onApplicationEvent(ProjectUpdatedEvent event) {
        Project project = (Project)event.getBefore();
        ArrayList history = Lists.newArrayList();
        ProjectConfiguration configuration = event.getUpdateProjectRQ().getConfiguration();
        if (null != configuration) {
            this.processKeepLogs((List)history, project, configuration);
            this.processKeepScreenshots((List)history, project, configuration);
            this.processLaunchInactivityTimeout((List)history, project, configuration);
            this.processAutoAnalyze((List)history, project, configuration);
            this.processStatisticsStrategy((List)history, project, configuration);
        }
        Activity activityLog = new ActivityBuilder().addProjectRef(project.getName()).addObjectType(ActivityObjectType.PROJECT).addObjectName(project.getName()).addActionType(ActivityEventType.UPDATE_PROJECT).addUserRef(event.getUpdatedBy()).addHistory((List)(history.isEmpty() ? null : history)).get();
        this.activityRepository.save((Object)activityLog);
    }

    private void processStatisticsStrategy(List<Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getStatisticCalculationStrategy() && !configuration.getStatisticCalculationStrategy().equalsIgnoreCase(project.getConfiguration().getStatisticsCalculationStrategy().name())) {
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)STATISTICS_CALCULATION_STRATEGY, (String)project.getConfiguration().getStatisticsCalculationStrategy().name(), (String)configuration.getStatisticCalculationStrategy());
            history.add(fieldValues);
        }
    }

    private void processKeepLogs(List<Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getKeepLogs() && !configuration.getKeepLogs().equals(project.getConfiguration().getKeepLogs())) {
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)KEEP_LOGS, (String)project.getConfiguration().getKeepLogs(), (String)configuration.getKeepLogs());
            history.add(fieldValues);
        }
    }

    private void processLaunchInactivityTimeout(List<Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getInterruptJobTime() && !configuration.getInterruptJobTime().equals(project.getConfiguration().getInterruptJobTime())) {
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)LAUNCH_INACTIVITY, (String)project.getConfiguration().getInterruptJobTime(), (String)configuration.getInterruptJobTime());
            history.add(fieldValues);
        }
    }

    private void processAutoAnalyze(List<Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getIsAAEnabled() && !configuration.getIsAAEnabled().equals(project.getConfiguration().getIsAutoAnalyzerEnabled())) {
            String oldValue = project.getConfiguration().getIsAutoAnalyzerEnabled() == null ? "" : project.getConfiguration().getIsAutoAnalyzerEnabled().toString();
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)AUTO_ANALYZE, (String)oldValue, (String)configuration.getIsAAEnabled().toString());
            history.add(fieldValues);
        }
    }

    private void processKeepScreenshots(List<Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getKeepScreenshots() && !configuration.getKeepScreenshots().equals(project.getConfiguration().getKeepScreenshots())) {
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)KEEP_SCREENSHOTS, (String)project.getConfiguration().getKeepScreenshots(), (String)configuration.getKeepScreenshots());
            history.add(fieldValues);
        }
    }
}

