/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class ApplicationContextAwareFactoryBean<T>
implements FactoryBean<T>,
ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private Supplier<T> beanSupplier;
    private boolean singleton = true;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public T getObject() throws Exception {
        return (T)this.beanSupplier.get();
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void afterPropertiesSet() throws Exception {
        Supplier supplier = () -> this.createInstance();
        this.beanSupplier = this.isSingleton() ? Suppliers.memoize((Supplier)supplier) : supplier;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected abstract T createInstance();
}

