/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.ws.model.ActivityResource;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ActivityConverter {
    public static final Function<Activity, ActivityResource> TO_RESOURCE = activity -> {
        Preconditions.checkNotNull((Object)activity);
        ActivityResource resource = new ActivityResource();
        resource.setUserRef(activity.getUserRef());
        resource.setProjectRef(activity.getProjectRef());
        resource.setActivityId(activity.getId());
        resource.setLoggedObjectRef(activity.getLoggedObjectRef());
        resource.setLastModifiedDate(activity.getLastModified());
        resource.setObjectType(activity.getObjectType().getValue());
        resource.setActionType(activity.getActionType().getValue());
        resource.setObjectName(activity.getName());
        List history = Optional.ofNullable(activity.getHistory()).orElseGet(Collections::emptyList).stream().map(TO_FIELD_RESOURCE).collect(Collectors.toList());
        resource.setHistory(history);
        return resource;
    };
    private static final Function<Activity.FieldValues, ActivityResource.FieldValues> TO_FIELD_RESOURCE = db -> {
        ActivityResource.FieldValues fieldValues = new ActivityResource.FieldValues();
        fieldValues.setField(db.getField());
        fieldValues.setOldValue(db.getOldValue());
        fieldValues.setNewValue(db.getNewValue());
        return fieldValues;
    };

    private ActivityConverter() {
    }
}

