/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.project.EntryType;
import com.epam.ta.reportportal.ws.model.project.ProjectInfoResource;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;

public final class ProjectInfoConverter {
    public static final Function<Project, ProjectInfoResource> TO_RESOURCE = project -> {
        Preconditions.checkNotNull((Object)project);
        ProjectInfoResource resource = new ProjectInfoResource();
        resource.setUsersQuantity(Integer.valueOf(null != project.getUsers() ? project.getUsers().size() : 0));
        resource.setProjectId(project.getId());
        resource.setCreationDate(project.getCreationDate());
        String entryType = Optional.ofNullable(project.getConfiguration()).map(Project.Configuration::getEntryType).map(Enum::name).orElse(EntryType.INTERNAL.name());
        resource.setEntryType(entryType);
        return resource;
    };

    private ProjectInfoConverter() {
    }
}

