/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.resolver;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.filter.PredefinedFilters;
import com.epam.ta.reportportal.database.search.CompositeFilter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PredefinedFilterCriteriaResolver
implements HandlerMethodArgumentResolver {
    public static final String FILTER_PARAMETER_NAME = "predefined_filter";

    public boolean supportsParameter(MethodParameter methodParameter) {
        return Queryable.class.isAssignableFrom(methodParameter.getParameterType()) && null != methodParameter.getParameterAnnotation(FilterFor.class);
    }

    public Queryable resolveArgument(MethodParameter methodParameter, ModelAndViewContainer paramModelAndViewContainer, NativeWebRequest webRequest, WebDataBinderFactory paramWebDataBinderFactory) throws Exception {
        Class domainModelType = ((FilterFor)methodParameter.getParameterAnnotation(FilterFor.class)).value();
        List filterConditions = webRequest.getParameterMap().entrySet().stream().filter(parameter -> FILTER_PARAMETER_NAME.equals(parameter.getKey())).map(parameter -> {
            BusinessRule.expect(parameter.getValue(), v -> null != v && ((String[])v).length == 1).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect filter value"});
            String filterName = ((String[])parameter.getValue())[0];
            BusinessRule.expect((Object)PredefinedFilters.hasFilter((String)filterName), Predicate.isEqual(true)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Unknown filter '" + filterName + "'"});
            Queryable queryable = PredefinedFilters.buildFilter((String)filterName, (String[])((String[])parameter.getValue()));
            BusinessRule.expect((Object)queryable.getTarget(), Predicate.isEqual(domainModelType)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect filter"});
            return queryable;
        }).collect(Collectors.toList());
        return filterConditions.isEmpty() ? this.nop(domainModelType) : new CompositeFilter(filterConditions);
    }

    private Queryable nop(Class<?> type) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

