/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.client;

import com.epam.ta.reportportal.core.analyzer.IAnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.client.ClientUtils;
import com.epam.ta.reportportal.core.analyzer.model.AnalyzedItemRs;
import com.epam.ta.reportportal.core.analyzer.model.IndexLaunch;
import com.epam.ta.reportportal.core.analyzer.model.IndexRs;
import com.epam.ta.reportportal.events.ConsulUpdateEvent;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AnalyzerServiceClient
implements IAnalyzerServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerServiceClient.class);
    static final String INDEX_PATH = "/_index";
    static final String ANALYZE_PATH = "/_analyze";
    private static final String ITEM_IDS_KEY = "ids";
    private static final String INDEX_NAME_KEY = "project";
    private final RestTemplate restTemplate;
    private final DiscoveryClient discoveryClient;
    private AtomicReference<List<ServiceInstance>> analyzerInstances = new AtomicReference(Collections.emptyList());

    @Autowired
    public AnalyzerServiceClient(RestTemplate restTemplate, DiscoveryClient discoveryClient) {
        this.restTemplate = restTemplate;
        this.discoveryClient = discoveryClient;
    }

    public boolean hasClients() {
        return !((List)this.analyzerInstances.get()).isEmpty();
    }

    public List<IndexRs> index(List<IndexLaunch> rq) {
        return ((List)this.analyzerInstances.get()).stream().filter(ClientUtils.SUPPORT_INDEX).map(instance -> this.index(instance, rq)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Map<String, List<AnalyzedItemRs>> analyze(IndexLaunch rq) {
        HashMap<String, List<AnalyzedItemRs>> result = new HashMap<String, List<AnalyzedItemRs>>(((List)this.analyzerInstances.get()).size());
        ((List)this.analyzerInstances.get()).forEach(instance -> {
            List analyzed = this.analyze(instance, rq);
            result.put((String)instance.getMetadata().get("analyzer"), analyzed);
            this.removeAnalyzedFromRq(rq, analyzed);
        });
        return result;
    }

    public void cleanIndex(String index, List<String> ids) {
        ((List)this.analyzerInstances.get()).stream().filter(ClientUtils.SUPPORT_INDEX).forEach(instance -> this.cleanIndex(instance, index, ids));
    }

    public void deleteIndex(String index) {
        ((List)this.analyzerInstances.get()).stream().filter(ClientUtils.SUPPORT_INDEX).forEach(instance -> this.deleteIndex(instance, index));
    }

    private void deleteIndex(ServiceInstance instance, String index) {
        try {
            this.restTemplate.delete(instance.getUri().toString() + INDEX_PATH + "/" + index, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Index deleting failed. Cannot interact with {} analyzer. Error: {}", instance.getMetadata().get("analyzer"), (Object)e);
        }
    }

    private void removeAnalyzedFromRq(IndexLaunch rq, List<AnalyzedItemRs> analyzed) {
        List analyzedItemIds = analyzed.stream().map(AnalyzedItemRs::getItemId).collect(Collectors.toList());
        rq.getTestItems().removeIf(it -> analyzedItemIds.contains(it.getTestItemId()));
    }

    private void cleanIndex(ServiceInstance instance, String project, List<String> ids) {
        try {
            this.restTemplate.put(instance.getUri().toString() + INDEX_PATH + "/delete", (Object)ImmutableMap.builder().put((Object)ITEM_IDS_KEY, ids).put((Object)INDEX_NAME_KEY, (Object)project).build(), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Documents deleting failed. Cannot interact with {} analyzer. Error: {}", instance.getMetadata().get("analyzer"), (Object)e);
        }
    }

    private Optional<IndexRs> index(ServiceInstance analyzer, List<IndexLaunch> rq) {
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(analyzer.getUri().toString() + INDEX_PATH, rq, IndexRs.class, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody());
        }
        catch (Exception e) {
            LOGGER.error("Indexing failed. Cannot interact with {} analyzer. Error: {}", analyzer.getMetadata().get("analyzer"), (Object)e);
            return Optional.empty();
        }
    }

    private List<AnalyzedItemRs> analyze(ServiceInstance analyzer, IndexLaunch rq) {
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(analyzer.getUri().toString() + ANALYZE_PATH, Collections.singletonList(rq), AnalyzedItemRs[].class, new Object[0]);
            AnalyzedItemRs[] rs = (AnalyzedItemRs[])responseEntity.getBody();
            return Arrays.asList(rs);
        }
        catch (Exception e) {
            LOGGER.error("Analyzing failed. Cannot interact with {} analyzer.", analyzer.getMetadata().get("analyzer"), (Object)e);
            return Collections.emptyList();
        }
    }

    @EventListener
    private void getAnalyzerServiceInstances(ConsulUpdateEvent event) {
        List collect = this.discoveryClient.getServices().stream().flatMap(service -> this.discoveryClient.getInstances(service).stream()).filter(instance -> instance.getMetadata().containsKey("analyzer")).sorted(Comparator.comparingInt(ClientUtils.SERVICE_PRIORITY)).collect(Collectors.toList());
        this.analyzerInstances.set(collect);
    }
}

