/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.dashboard.IGetDashboardHandler;
import com.epam.ta.reportportal.database.dao.DashboardRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.ws.converter.DashboardResourceAssembler;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class GetDashboardHandler
implements IGetDashboardHandler {
    private final DashboardRepository dashboardRepository;
    private final DashboardResourceAssembler resourceAssembler;
    private final Sort creationDateSort;
    private final Function<Dashboard, SharedEntity> TO_SHARED_ENTITY = dashboard -> {
        SharedEntity sharedEntity = new SharedEntity();
        sharedEntity.setId(dashboard.getId());
        sharedEntity.setName(dashboard.getName());
        Optional.ofNullable(dashboard.getAcl()).ifPresent(acl -> sharedEntity.setOwner(acl.getOwnerUserId()));
        sharedEntity.setDescription(dashboard.getDescription());
        return sharedEntity;
    };

    @Autowired
    public GetDashboardHandler(DashboardRepository dashboardRepository, DashboardResourceAssembler resourceAssembler) {
        this.creationDateSort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "creationDate")});
        this.dashboardRepository = dashboardRepository;
        this.resourceAssembler = resourceAssembler;
    }

    public DashboardResource getDashboard(String dashboardId, String userName, String projectName) {
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
        BusinessRule.expect((Object)dashboard, (Predicate)Predicates.notNull()).verify(ErrorType.DASHBOARD_NOT_FOUND, new Object[]{dashboardId});
        AclUtils.isPossibleToRead((Acl)dashboard.getAcl(), (String)userName, (String)projectName);
        BusinessRule.expect((Object)dashboard.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        return this.resourceAssembler.toResource(dashboard);
    }

    public Iterable<DashboardResource> getAllDashboards(String userName, String projectName) {
        List dashboards = this.dashboardRepository.findAll(userName, this.creationDateSort, projectName);
        return this.resourceAssembler.toResources((Iterable)dashboards);
    }

    public Iterable<SharedEntity> getSharedDashboardsNames(String ownerName, String projectName, Pageable pageable) {
        Page page = this.dashboardRepository.findSharedEntities(projectName, (List)Lists.newArrayList((Object[])new String[]{"_id", "name", "acl.ownerUserId", "description"}), Shareable.NAME_OWNER_SORT, pageable);
        return (Iterable)PagedResourcesAssembler.pageConverter((Function)this.TO_SHARED_ENTITY).apply(page);
    }
}

