/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.core.item.UniqueIdGenerator;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestItemUniqueIdGenerator
implements UniqueIdGenerator {
    private static final String TRAIT = "auto:";
    private TestItemRepository testItemRepository;
    private LaunchRepository launchRepository;

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    public String generate(TestItem testItem) {
        String forEncoding = this.prepareForEncoding(testItem);
        return TRAIT + DigestUtils.md5Hex((String)forEncoding);
    }

    public boolean validate(String encoded) {
        return !Strings.isNullOrEmpty((String)encoded) && encoded.startsWith(TRAIT);
    }

    private String prepareForEncoding(TestItem testItem) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        String launchName = launch.getName();
        String projectName = launch.getProjectRef();
        List pathNames = this.getPathNames(testItem.getPath());
        String itemName = testItem.getName();
        List parameters = Optional.ofNullable(testItem.getParameters()).orElse(Collections.emptyList());
        StringJoiner joiner = new StringJoiner(";");
        joiner.add(projectName).add(launchName);
        if (!CollectionUtils.isEmpty((Collection)pathNames)) {
            joiner.add(pathNames.stream().collect(Collectors.joining(",")));
        }
        joiner.add(itemName);
        if (!parameters.isEmpty()) {
            joiner.add(parameters.stream().map(parameter -> (!Strings.isNullOrEmpty((String)parameter.getKey()) ? parameter.getKey() + "=" : "") + parameter.getValue()).collect(Collectors.joining(",")));
        }
        return joiner.toString();
    }

    private List<String> getPathNames(List<String> path) {
        Map names = this.testItemRepository.findPathNames(path);
        return path.stream().map(names::get).collect(Collectors.toList());
    }
}

