/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.BusinessRuleViolationException;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.impl.IssuesAnalyzerService;
import com.epam.ta.reportportal.core.analyzer.impl.LogIndexerService;
import com.epam.ta.reportportal.core.item.TestItemUtils;
import com.epam.ta.reportportal.core.item.UpdateTestItemHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.statistics.StatisticSubType;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.events.ItemIssueTypeDefined;
import com.epam.ta.reportportal.events.TicketAttachedEvent;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.ws.converter.converters.IssueConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.issue.DefineIssueRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.issue.IssueDefinition;
import com.epam.ta.reportportal.ws.model.item.AddExternalIssueRQ;
import com.epam.ta.reportportal.ws.model.item.UpdateTestItemRQ;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateTestItemHandlerImpl
implements UpdateTestItemHandler {
    private final ApplicationEventPublisher eventPublisher;
    private final TestItemRepository testItemRepository;
    private final StatisticsFacadeFactory statisticsFacadeFactory;
    private final UserRepository userRepository;
    private final ProjectRepository projectRepository;
    private final LaunchRepository launchRepository;
    private final ExternalSystemRepository externalSystemRepository;
    private final LogIndexerService logIndexer;
    private final IssuesAnalyzerService issuesAnalyzerService;

    @Autowired
    public UpdateTestItemHandlerImpl(TestItemRepository testItemRepository, StatisticsFacadeFactory statisticsFacadeFactory, UserRepository userRepository, ProjectRepository projectRepository, LaunchRepository launchRepository, ExternalSystemRepository externalSystemRepository, ApplicationEventPublisher eventPublisher, LogIndexerService logIndexer, IssuesAnalyzerService issuesAnalyzerService) {
        this.eventPublisher = eventPublisher;
        this.testItemRepository = testItemRepository;
        this.statisticsFacadeFactory = statisticsFacadeFactory;
        this.userRepository = userRepository;
        this.projectRepository = projectRepository;
        this.launchRepository = launchRepository;
        this.externalSystemRepository = externalSystemRepository;
        this.logIndexer = logIndexer;
        this.issuesAnalyzerService = issuesAnalyzerService;
    }

    public List<Issue> defineTestItemsIssues(String projectName, DefineIssueRQ defineIssue, String userName) {
        ArrayList<String> errors = new ArrayList<String>();
        List definitions = defineIssue.getIssues();
        BusinessRule.expect((Object)definitions, (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[]{""});
        ArrayList<Issue> updated = new ArrayList<Issue>(defineIssue.getIssues().size());
        ImmutableMap.Builder eventData = ImmutableMap.builder();
        for (IssueDefinition issueDefinition : definitions) {
            try {
                TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)issueDefinition.getId()));
                this.verifyTestItem(testItem, issueDefinition.getId());
                issueDefinition.getIssue().setAutoAnalyzed(false);
                eventData.put((Object)issueDefinition, (Object)testItem);
                Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
                Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
                Issue issue = issueDefinition.getIssue();
                String issueType = this.verifyTestItemDefinedIssueType(issue.getIssueType(), project.getConfiguration());
                testItem = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).resetIssueStatistics(testItem);
                TestItemIssue testItemIssue = testItem.getIssue();
                testItemIssue.setIssueType(issueType);
                String comment = issueDefinition.getIssue().getComment();
                if (null != comment) {
                    comment = comment.trim();
                }
                if (null != issue.getExternalSystemIssues()) {
                    Set issuesFromDB = null == testItemIssue.getExternalSystemIssues() ? new HashSet() : testItemIssue.getExternalSystemIssues();
                    Set issuesFromRequest = issue.getExternalSystemIssues().stream().map(TestItemUtils.externalIssueDtoConverter((String)userName)).collect(Collectors.toSet());
                    HashSet difference = Sets.newHashSet((Iterable)Sets.difference(issuesFromRequest, issuesFromDB));
                    if (!difference.isEmpty()) {
                        Set<Object> externalSystemIssues;
                        for (TestItemIssue.ExternalSystemIssue externalSystemIssue : difference) {
                            externalSystemIssue.setSubmitter(userName);
                            externalSystemIssue.setSubmitDate(Long.valueOf(new Date().getTime()));
                        }
                        if (issuesFromRequest.size() < issuesFromDB.size()) {
                            issuesFromRequest.removeAll(difference);
                            issuesFromRequest.addAll(difference);
                            externalSystemIssues = issuesFromRequest;
                        } else {
                            externalSystemIssues = issuesFromDB;
                            externalSystemIssues.addAll(difference);
                        }
                        testItemIssue.setExternalSystemIssues(externalSystemIssues);
                    } else {
                        issuesFromDB.removeAll(Sets.newHashSet((Iterable)Sets.difference(issuesFromDB, issuesFromRequest)));
                        testItemIssue.setExternalSystemIssues(issuesFromDB);
                    }
                }
                testItemIssue.setIgnoreAnalyzer(this.issuesAnalyzerService.hasAnalyzers() && issue.getIgnoreAnalyzer());
                testItemIssue.setAutoAnalyzed(issue.getAutoAnalyzed());
                testItemIssue.setIssueDescription(comment);
                testItem.setIssue(testItemIssue);
                this.testItemRepository.save((Object)testItem);
                this.indexLogs(projectName, testItem);
                testItem = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).updateIssueStatistics(testItem);
                updated.add((Issue)IssueConverter.TO_MODEL.apply(testItem.getIssue()));
            }
            catch (BusinessRuleViolationException e) {
                errors.add(e.getMessage());
            }
        }
        BusinessRule.expect((Object)(!errors.isEmpty() ? 1 : 0), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[]{((Object)errors).toString()});
        this.eventPublisher.publishEvent((Object)new ItemIssueTypeDefined((Map)eventData.build(), userName, projectName));
        return updated;
    }

    public OperationCompletionRS updateTestItem(String projectName, String item, UpdateTestItemRQ rq, String userName) {
        TestItem testItem = this.validate(projectName, userName, item);
        Optional.ofNullable(rq.getTags()).ifPresent(tags -> testItem.setTags((Set)Sets.newHashSet((Iterable)EntityUtils.trimStrings((Iterable)EntityUtils.update((Iterable)tags)))));
        Optional.ofNullable(rq.getDescription()).ifPresent(arg_0 -> ((TestItem)testItem).setItemDescription(arg_0));
        this.testItemRepository.save((Object)testItem);
        return new OperationCompletionRS("TestItem with ID = '" + item + "' successfully updated.");
    }

    public List<OperationCompletionRS> addExternalIssues(String projectName, AddExternalIssueRQ rq, String userName) {
        ArrayList errors = new ArrayList();
        ExternalSystem extSystem = (ExternalSystem)this.externalSystemRepository.findOne((Serializable)((Object)rq.getExternalSystemId()));
        BusinessRule.expect((Object)extSystem, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{rq.getExternalSystemId()});
        Iterable testItems = this.testItemRepository.findAll((Iterable)rq.getTestItemIds());
        List before = (List)((Object)SerializationUtils.clone((Serializable)Lists.newArrayList((Iterable)testItems)));
        StreamSupport.stream(testItems.spliterator(), false).forEach(testItem -> {
            try {
                this.verifyTestItem(testItem, testItem.getId());
                Set tiIssues = rq.getIssues().stream().filter(issue -> !issue.getTicketId().trim().isEmpty()).map(TestItemUtils.externalIssueDtoConverter((String)rq.getExternalSystemId(), (String)userName)).collect(Collectors.toSet());
                if (null == testItem.getIssue().getExternalSystemIssues()) {
                    testItem.getIssue().setExternalSystemIssues(tiIssues);
                } else {
                    tiIssues.addAll(testItem.getIssue().getExternalSystemIssues());
                    testItem.getIssue().setExternalSystemIssues(tiIssues);
                }
            }
            catch (BusinessRuleViolationException e) {
                errors.add(e.getMessage());
            }
        });
        BusinessRule.expect((Object)(!errors.isEmpty() ? 1 : 0), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[]{((Object)errors).toString()});
        this.testItemRepository.save(testItems);
        this.eventPublisher.publishEvent((Object)new TicketAttachedEvent(before, (List)Lists.newArrayList((Iterable)testItems), userName, projectName));
        return StreamSupport.stream(testItems.spliterator(), false).map(testItem -> new OperationCompletionRS("TestItem with ID = '" + testItem.getId() + "' successfully updated.")).collect(Collectors.toList());
    }

    private TestItem validate(String projectName, String userName, String id) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)id));
        BusinessRule.expect((Object)testItem, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{id});
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
        String launchOwner = launch.getUserRef();
        if (((User)this.userRepository.findOne((Serializable)((Object)userName))).getRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)projectName, (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)project.getName())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            if (ProjectUtils.doesHaveUser((Project)project, (String)userName) && ProjectUtils.findUserConfigByLogin((Project)project, (String)userName).getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)userName, (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)launchOwner)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            }
        }
        return testItem;
    }

    private void indexLogs(String projectName, TestItem testItem) {
        if (Predicates.ITEM_CAN_BE_INDEXED.test(testItem)) {
            this.logIndexer.indexLogs(testItem.getLaunchRef(), Collections.singletonList(testItem));
        } else {
            this.logIndexer.cleanIndex(projectName, Collections.singletonList(testItem.getId()));
        }
    }

    private String verifyTestItemDefinedIssueType(String type, Project.Configuration settings) {
        StatisticSubType defined = settings.getByLocator(type);
        BusinessRule.expect((Object)defined, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.AMBIGUOUS_TEST_ITEM_STATUS, new Object[]{Suppliers.formattedSupplier((String)"Invalid test item issue type definition '{}'. Valid issue types locators are: {}", (Object[])new Object[]{type, settings.getSubTypes().values().stream().flatMap(Collection::stream).map(StatisticSubType::getLocator).collect(Collectors.toList())})});
        return defined.getLocator();
    }

    private void verifyTestItem(TestItem testItem, String id) throws BusinessRuleViolationException {
        BusinessRule.expect((Object)testItem, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull(), (Supplier)Suppliers.formattedSupplier((String)"Cannot update issue type for test item '{}', cause it is not found.", (Object[])new Object[]{id})).verify();
        BusinessRule.expect((Object)testItem.getStatus(), (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Status.PASSED)), (Supplier)Suppliers.formattedSupplier((String)"Issue status update cannot be applied on {} test items, cause it is not allowed.", (Object[])new Object[]{Status.PASSED.name()})).verify();
        BusinessRule.expect((Object)testItem.hasChilds(), (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.TRUE)), (Supplier)Suppliers.formattedSupplier((String)"It is not allowed to udpate issue type for items with descendants. Test item '{}' has descendants.", (Object[])new Object[]{id})).verify();
        BusinessRule.expect((Object)testItem.getIssue(), (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull(), (Supplier)Suppliers.formattedSupplier((String)"Cannot update issue type for test item '{}', cause there is no info about actual issue type value.", (Object[])new Object[]{id})).verify();
        BusinessRule.expect((Object)testItem.getIssue().getIssueType(), (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull(), (Supplier)Suppliers.formattedSupplier((String)"Cannot update issue type for test item {}, cause it's actual issue type value is not provided.", (Object[])new Object[]{id})).verify();
    }
}

