/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.history;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.item.history.HistoryUtils;
import com.epam.ta.reportportal.core.item.history.ITestItemsHistoryService;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.converter.TestItemResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.TestItemHistoryElement;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class TestItemsHistoryService
implements ITestItemsHistoryService {
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private TestItemResourceAssembler itemResourceAssembler;

    public List<Launch> loadLaunches(int quantity, String startingLaunchId, String projectName, boolean showBrokenLaunches) {
        Launch startingLaunch = this.launchRepository.findNameNumberAndModeById(startingLaunchId);
        if (startingLaunch == null) {
            return Collections.emptyList();
        }
        if (startingLaunch.getMode() == Mode.DEBUG) {
            return Collections.singletonList(startingLaunch);
        }
        Filter filter = HistoryUtils.getLaunchSelectionFilter((String)startingLaunch.getName(), (String)projectName, (String)startingLaunch.getNumber().toString(), (boolean)showBrokenLaunches);
        return this.launchRepository.findIdsByFilter(filter, new Sort(Sort.Direction.DESC, new String[]{"number"}), quantity);
    }

    public TestItemHistoryElement buildHistoryElement(Launch launch, List<TestItem> testItems) {
        List<Object> resources = new ArrayList();
        if (testItems != null) {
            resources = testItems.stream().map(item -> this.itemResourceAssembler.toResource(item, launch.getStatus().name())).collect(Collectors.toList());
        }
        TestItemHistoryElement testItemHistoryElement = new TestItemHistoryElement();
        testItemHistoryElement.setLaunchId(launch.getId());
        testItemHistoryElement.setLaunchNumber(launch.getNumber().toString());
        testItemHistoryElement.setStartTime(String.valueOf(launch.getStartTime().getTime()));
        testItemHistoryElement.setResources(resources);
        testItemHistoryElement.setLaunchStatus(launch.getStatus().name());
        return testItemHistoryElement;
    }

    public void validateHistoryRequest(String projectName, String[] startPointsIds, int historyDepth) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        Predicate<Integer> greaterThan = t -> t > 0;
        Predicate<Integer> lessThan = t -> t < 31;
        String historyDepthMessage = "Items history depth should be greater than '0' and lower than '31'";
        BusinessRule.expect((Object)historyDepth, greaterThan.and(lessThan)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{historyDepthMessage});
        BusinessRule.expect((Object)startPointsIds.length, t -> t < 31).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"History size should be less than '31' test items."});
    }

    public void validateItems(List<TestItem> itemsForHistory, List<String> ids, String projectName) {
        BusinessRule.expect(itemsForHistory, (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find history for items '" + ids + "'."});
        Set projectIds = this.launchRepository.find((Collection)itemsForHistory.stream().map(TestItem::getLaunchRef).collect(Collectors.toList())).stream().map(Launch::getProjectRef).collect(Collectors.toSet());
        BusinessRule.expect((Object)(projectIds.size() == 1 && projectIds.contains(projectName) ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find history for items '" + ids + "'."});
        ids.removeAll(itemsForHistory.stream().map(TestItem::getId).collect(Collectors.toList()));
        BusinessRule.expect((Object)ids.isEmpty(), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find history for items '" + ids + "'."});
        this.checkItemsIsSiblings(itemsForHistory);
    }

    private void checkItemsIsSiblings(List<TestItem> itemsForHistory) {
        String parentId = itemsForHistory.get(0).getParent();
        if (parentId == null) {
            String launchRef = itemsForHistory.get(0).getLaunchRef();
            for (TestItem testItem : itemsForHistory) {
                BusinessRule.expect((Object)testItem, (Predicate)Preconditions.hasSameLaunch((String)launchRef)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"All test items should be siblings."});
            }
        } else {
            BusinessRule.expect(itemsForHistory, (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.not((Predicate)Preconditions.hasSameParent((String)parentId))))).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"All test items should be siblings."});
        }
    }
}

