/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.launch.IRetriesLaunchHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsFacade;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.history.status.RetryObject;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetriesLaunchHandler
implements IRetriesLaunchHandler {
    private static final int MINIMUM_RETRIES_COUNT = 2;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;

    public void handleRetries(Launch launch) {
        if (BooleanUtils.isTrue((Boolean)launch.getHasRetries())) {
            List retries = this.testItemRepository.findRetries(launch.getId());
            boolean hasRetries = retries.stream().anyMatch(it -> it.getRetries().size() >= 2);
            if (!hasRetries) {
                this.launchRepository.updateHasRetries(launch.getId(), false);
                return;
            }
            Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
            StatisticsFacade statisticsFacade = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy());
            BusinessRule.expect((Object)retries, (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{"There are no retries in the launch."});
            retries.forEach(retry -> this.handleRetry(retry, statisticsFacade));
        }
    }

    private void handleRetry(RetryObject retry, StatisticsFacade statisticsFacade) {
        List retries = retry.getRetries();
        retries.forEach(it -> BusinessRule.expect((Object)it.hasChilds(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{"Retries cannot have items with children"}));
        TestItem lastRetry = this.moveRetries(retries, statisticsFacade);
        this.testItemRepository.delete((Iterable)retries);
        this.testItemRepository.save((Object)lastRetry);
        statisticsFacade.updateParentStatusFromStatistics(lastRetry);
        statisticsFacade.updateLaunchFromStatistics((Launch)this.launchRepository.findOne((Serializable)((Object)lastRetry.getLaunchRef())));
    }

    private TestItem resetRetryStatistics(TestItem retry, StatisticsFacade statisticsFacade) {
        if ((retry = statisticsFacade.resetExecutionStatistics(retry)).getIssue() != null) {
            retry = statisticsFacade.resetIssueStatistics(retry);
        }
        return retry;
    }

    private TestItem moveRetries(List<TestItem> retries, StatisticsFacade statisticsFacade) {
        retries.forEach(it -> {
            this.resetRetryStatistics(it, statisticsFacade);
            it.setRetryProcessed(Boolean.TRUE);
        });
        TestItem retryRoot = retries.get(0);
        retries.set(0, retryRoot);
        TestItem lastRetry = retries.get(retries.size() - 1);
        retries.remove(retries.size() - 1);
        lastRetry = this.updateRetryStatistics(lastRetry, statisticsFacade);
        lastRetry.setStartTime(retryRoot.getStartTime());
        lastRetry.setRetries(retries);
        return lastRetry;
    }

    private TestItem updateRetryStatistics(TestItem lastRetry, StatisticsFacade statisticsFacade) {
        if ((lastRetry = statisticsFacade.updateExecutionStatistics(lastRetry)).getIssue() != null) {
            lastRetry = statisticsFacade.updateIssueStatistics(lastRetry);
        }
        return lastRetry;
    }
}

