/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.core.widget.content.WidgetContentProvider;
import com.epam.ta.reportportal.database.StatisticsDocumentHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.stereotype.Service;

@Service
public class CumulativeContentLoader
implements IContentLoadingStrategy {
    private static final String TAG_PREFIX = "prefix";
    @Autowired
    private LaunchRepository launchRepository;

    public Map<String, List<ChartObject>> loadContent(String projectName, Filter filter, Sort sorting, int quantity, List<String> contentFields, List<String> metaDataFields, Map<String, List<String>> widgetsOptions) {
        Map<String, List<ChartObject>> emptyResult = Collections.emptyMap();
        List<String> options = widgetsOptions.get(TAG_PREFIX);
        BusinessRule.expect(options, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"widgetOptions"});
        BusinessRule.expect((Object)options.isEmpty(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{TAG_PREFIX});
        List fields = contentFields.stream().map(WidgetContentProvider.TO_UI_STYLE).collect(Collectors.toList());
        StatisticsDocumentHandler handler = new StatisticsDocumentHandler(fields, metaDataFields);
        this.launchRepository.cumulativeStatisticsGroupedByTag((Queryable)filter, contentFields, (long)quantity, options.get(0), (DocumentCallbackHandler)handler);
        List result = handler.getResult();
        if (null == result) {
            return emptyResult;
        }
        Collections.reverse(result);
        return ImmutableMap.builder().put((Object)"result", (Object)result).build();
    }
}

