/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.project.KeepLogsDelay;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CleanLogsJob
implements Job {
    private static final Duration MIN_DELAY = Duration.ofDays(KeepLogsDelay.TWO_WEEKS.getDays() - 1L);
    private static final Duration MAX_DELAY = Duration.ofDays(KeepLogsDelay.SIX_MONTHS.getDays() + 1L);
    @Autowired
    private LogRepository logRepo;
    @Autowired
    private LaunchRepository launchRepo;
    @Autowired
    private TestItemRepository testItemRepo;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private ActivityRepository activityRepository;

    public void execute(JobExecutionContext context) {
        try (Stream stream = this.projectRepository.streamAllIdsAndConfiguration();){
            stream.forEach(project -> {
                Duration period = Duration.ofDays(KeepLogsDelay.findByName((String)project.getConfiguration().getKeepLogs()).getDays());
                if (!period.isZero()) {
                    this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
                    this.removeOutdatedLogs(project.getId(), period);
                }
            });
        }
    }

    private void removeOutdatedLogs(String projectId, Duration period) {
        try (Stream launchStream = this.streamLaunches(projectId);){
            launchStream.forEach(launch -> {
                try (Stream testItemStream = this.testItemRepo.streamIdsByLaunch(launch.getId());){
                    this.logRepo.deleteByPeriodAndItemsRef(period, testItemStream.map(TestItem::getId).collect(Collectors.toList()));
                }
            });
        }
    }

    private Stream<Launch> streamLaunches(String projectId) {
        Date beginDate = Date.from(Instant.now().minusSeconds(MAX_DELAY.getSeconds()));
        Date endDate = Date.from(Instant.now().minusSeconds(MIN_DELAY.getSeconds()));
        return this.launchRepo.streamModifiedInRange(projectId, beginDate, endDate);
    }
}

