/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.catalog.CatalogClient;
import com.epam.ta.reportportal.events.ConsulUpdateEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!unittest"})
public class ConsulUpdateListener
extends AbstractExecutionThreadService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulUpdateListener.class);
    private static final int TIMEOUT_IN_SEC = 50;
    private ApplicationEventPublisher eventPublisher;
    private CatalogClient catalogClient;
    private long xConsulIndex;

    @Autowired
    public ConsulUpdateListener(CatalogClient catalogClient, ApplicationEventPublisher eventPublisher) {
        this.catalogClient = catalogClient;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void onApplicationReady(ApplicationReadyEvent event) {
        try {
            this.startAsync().awaitRunning(5L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            throw new ReportPortalException("Cannot start consul listener.", (Throwable)e);
        }
    }

    protected void run() {
        while (this.isRunning()) {
            try {
                this.xConsulIndex = this.catalogClient.getCatalogServices(QueryParams.Builder.builder().setIndex(this.xConsulIndex).setWaitTime(50L).build()).getConsulIndex();
                this.eventPublisher.publishEvent((Object)new ConsulUpdateEvent());
            }
            catch (Exception e) {
                this.xConsulIndex = 0L;
                LOGGER.error("Problem interacting with consul. Trying again.", (Throwable)e);
            }
        }
    }
}

