/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.UserPreference;
import com.epam.ta.reportportal.ws.model.preference.PreferenceResource;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;

public final class PreferenceConverter {
    public static final Function<UserPreference, PreferenceResource> TO_RESOURCE = preference -> {
        Preconditions.checkNotNull((Object)preference);
        PreferenceResource preferenceResource = new PreferenceResource();
        preferenceResource.setUserRef(preference.getUserRef());
        preferenceResource.setProjectRef(preference.getProjectRef());
        UserPreference.LaunchTabs tabs = preference.getLaunchTabs();
        Optional.ofNullable(tabs).ifPresent(it -> {
            preferenceResource.setActive(it.getActive());
            preferenceResource.setFilters(it.getFilters());
        });
        return preferenceResource;
    };

    private PreferenceConverter() {
    }
}

