/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.ws.converter.converters.IssueConverter;
import com.epam.ta.reportportal.ws.converter.converters.ParametersConverter;
import com.epam.ta.reportportal.ws.converter.converters.StatisticsConverter;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.statistics.Statistics;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TestItemConverter {
    public static final Function<TestItem, TestItemResource> TO_RESOURCE = item -> {
        Preconditions.checkNotNull((Object)item);
        TestItemResource resource = new TestItemResource();
        resource.setDescription(item.getItemDescription());
        resource.setUniqueId(item.getUniqueId());
        resource.setTags(item.getTags());
        resource.setEndTime(item.getEndTime());
        resource.setItemId(item.getId());
        if (null != item.getParameters()) {
            resource.setParameters(item.getParameters().stream().map(ParametersConverter.TO_RESOURCE).collect(Collectors.toList()));
        }
        resource.setIssue((Issue)IssueConverter.TO_MODEL.apply(item.getIssue()));
        resource.setName(item.getName());
        resource.setStartTime(item.getStartTime());
        resource.setStatus(item.getStatus() != null ? item.getStatus().toString() : null);
        resource.setType(item.getType() != null ? item.getType().name() : null);
        resource.setParent(item.getParent());
        resource.setHasChilds(item.hasChilds());
        resource.setLaunchId(item.getLaunchRef());
        resource.setStatistics((Statistics)StatisticsConverter.TO_RESOURCE.apply(item.getStatistics()));
        Optional.ofNullable(item.getRetries()).map(items -> items.stream().map(TO_RESOURCE).sorted(Comparator.comparing(TestItemResource::getStartTime)).collect(Collectors.toList())).ifPresent(arg_0 -> ((TestItemResource)resource).setRetries(arg_0));
        return resource;
    };

    private TestItemConverter() {
    }
}

