/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.impl;

import com.epam.ta.reportportal.core.analyzer.IAnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.IIssuesAnalyzer;
import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.core.analyzer.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.model.AnalyzedItemRs;
import com.epam.ta.reportportal.core.analyzer.model.IndexLaunch;
import com.epam.ta.reportportal.core.analyzer.model.IndexTestItem;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.AnalyzeMode;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.LogLevel;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.events.ItemIssueTypeDefined;
import com.epam.ta.reportportal.events.TicketAttachedEvent;
import com.epam.ta.reportportal.ws.converter.converters.IssueConverter;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.issue.IssueDefinition;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class IssuesAnalyzerService
implements IIssuesAnalyzer {
    @Autowired
    private IAnalyzerServiceClient analyzerServiceClient;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private ILogIndexer logIndexer;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public boolean hasAnalyzers() {
        return this.analyzerServiceClient.hasClients();
    }

    public void analyze(Launch launch, List<TestItem> testItems, AnalyzeMode analyzeMode) {
        List rqTestItems;
        Map rs;
        if (launch != null && !MapUtils.isEmpty((Map)(rs = this.analyze(rqTestItems = this.prepareItems(testItems), launch, analyzeMode)))) {
            List updatedItems = rs.entrySet().stream().flatMap(it -> this.updateTestItems((String)it.getKey(), (List)it.getValue(), testItems, launch.getProjectRef()).stream()).collect(Collectors.toList());
            this.saveUpdatedItems(updatedItems, launch);
            this.logIndexer.indexLogs(launch.getId(), updatedItems);
        }
    }

    private Map<String, List<AnalyzedItemRs>> analyze(List<IndexTestItem> rqTestItems, Launch launch, AnalyzeMode analyzeMode) {
        if (!rqTestItems.isEmpty()) {
            IndexLaunch rqLaunch = new IndexLaunch();
            rqLaunch.setAnalyzeMode(analyzeMode.getValue());
            rqLaunch.setLaunchId(launch.getId());
            rqLaunch.setLaunchName(launch.getName());
            rqLaunch.setProject(launch.getProjectRef());
            rqLaunch.setTestItems(rqTestItems);
            return this.analyzerServiceClient.analyze(rqLaunch);
        }
        return Collections.emptyMap();
    }

    private List<IndexTestItem> prepareItems(List<TestItem> testItems) {
        return testItems.stream().map(it -> AnalyzerUtils.fromTestItem((TestItem)it, (List)this.logRepository.findGreaterOrEqualLevel(Collections.singletonList(it.getId()), LogLevel.ERROR))).filter(it -> !CollectionUtils.isEmpty((Collection)it.getLogs())).collect(Collectors.toList());
    }

    private List<TestItem> updateTestItems(String analyzerInstance, List<AnalyzedItemRs> rs, List<TestItem> testItems, String project) {
        HashMap forEvents = new HashMap();
        ArrayList beforeUpdate = new ArrayList(rs.size());
        List<TestItem> updatedItems = rs.stream().map(analyzed -> {
            Optional<TestItem> toUpdate = testItems.stream().filter(item -> item.getId().equals(analyzed.getItemId())).findAny();
            toUpdate.ifPresent(testItem -> {
                beforeUpdate.add(SerializationUtils.clone((Serializable)testItem));
                TestItemIssue issue = new TestItemIssue(analyzed.getIssueType(), null, true);
                issue.setIgnoreAnalyzer(testItem.getIssue().isIgnoreAnalyzer());
                Optional.ofNullable(analyzed.getRelevantItemId()).ifPresent(relevantItemId -> this.fromRelevantItem(issue, relevantItemId));
                IssueDefinition issueDefinition = this.createIssueDefinition(testItem.getId(), issue);
                forEvents.put(issueDefinition, SerializationUtils.clone((Serializable)testItem));
                testItem.setIssue(issue);
            });
            return toUpdate;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        this.eventPublisher.publishEvent((Object)new ItemIssueTypeDefined(forEvents, analyzerInstance, project));
        this.eventPublisher.publishEvent((Object)new TicketAttachedEvent(beforeUpdate, updatedItems, analyzerInstance, project));
        return updatedItems;
    }

    private IssueDefinition createIssueDefinition(String id, TestItemIssue issue) {
        IssueDefinition issueDefinition = new IssueDefinition();
        issueDefinition.setId(id);
        issueDefinition.setIssue((Issue)IssueConverter.TO_MODEL.apply(issue));
        return issueDefinition;
    }

    private void fromRelevantItem(TestItemIssue issue, String relevantItemId) {
        TestItem relevantItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)relevantItemId));
        if (relevantItem != null && relevantItem.getIssue() != null) {
            issue.setIssueDescription(Strings.emptyToNull((String)(Strings.nullToEmpty((String)issue.getIssueDescription()) + Strings.nullToEmpty((String)relevantItem.getIssue().getIssueDescription()))));
            issue.setExternalSystemIssues(relevantItem.getIssue().getExternalSystemIssues());
        }
    }

    private void saveUpdatedItems(List<TestItem> items, Launch launch) {
        Map<String, TestItemIssue> forUpdate = items.stream().collect(Collectors.toMap(TestItem::getId, TestItem::getIssue));
        if (!forUpdate.isEmpty()) {
            this.testItemRepository.updateItemsIssues(forUpdate);
            Project project = this.projectRepository.findByName(launch.getProjectRef());
            this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).recalculateStatistics(launch);
        }
    }
}

