/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.configs.SchedulerConfiguration;
import com.epam.ta.reportportal.job.CleanLogsJob;
import com.epam.ta.reportportal.job.CleanScreenshotsJob;
import com.epam.ta.reportportal.job.InterruptBrokenLaunchesJob;
import java.time.Duration;
import java.util.List;
import javax.inject.Named;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableConfigurationProperties(value={QuartzProperties.class})
public class SchedulerConfiguration {
    @Autowired
    List<Trigger> listOfTrigger;
    @Autowired
    private QuartzProperties quartzProperties;
    @Autowired
    private AutowireCapableBeanFactory context;

    @Bean
    @Primary
    public SchedulerFactoryBean schedulerFactoryBean() {
        SchedulerFactoryBean scheduler = new SchedulerFactoryBean();
        scheduler.setApplicationContextSchedulerContextKey("applicationContext");
        scheduler.setQuartzProperties(this.quartzProperties.getQuartz());
        scheduler.setAutoStartup(true);
        scheduler.setWaitForJobsToCompleteOnShutdown(true);
        scheduler.setJobFactory((JobFactory)this.beanJobFactory());
        if (null != this.listOfTrigger && !this.listOfTrigger.isEmpty()) {
            scheduler.setTriggers(this.listOfTrigger.toArray(new Trigger[this.listOfTrigger.size()]));
        }
        return scheduler;
    }

    @Bean
    public SpringBeanJobFactory beanJobFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SimpleTriggerFactoryBean createCleanLogsTrigger(@Named(value="cleanLogsJob") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.clean.logs.cron}") String cleanLogsCron) {
        return SchedulerConfiguration.createTrigger((JobDetail)jobDetail, (long)Duration.parse(cleanLogsCron).toMillis());
    }

    @Bean
    public SimpleTriggerFactoryBean interruptLaunchesTrigger(@Autowired @Named(value="interruptLaunchesJob") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.interrupt.broken.launches.cron}") String interruptLaunchesCron) {
        return SchedulerConfiguration.createTrigger((JobDetail)jobDetail, (long)Duration.parse(interruptLaunchesCron).toMillis());
    }

    @Bean
    public SimpleTriggerFactoryBean cleanScreenshotsTrigger(@Named(value="cleanScreenshotsJob") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.clean.screenshots.cron}") String cleanScreenshotsCron) {
        return SchedulerConfiguration.createTrigger((JobDetail)jobDetail, (long)Duration.parse(cleanScreenshotsCron).toMillis());
    }

    @Bean
    @Named(value="cleanLogsJob")
    public static JobDetailFactoryBean cleanLogsJob() {
        return SchedulerConfiguration.createJobDetail(CleanLogsJob.class);
    }

    @Bean
    @Named(value="interruptLaunchesJob")
    public static JobDetailFactoryBean interruptLaunchesJob() {
        return SchedulerConfiguration.createJobDetail(InterruptBrokenLaunchesJob.class);
    }

    @Bean
    @Named(value="cleanScreenshotsJob")
    public static JobDetailFactoryBean cleanScreenshotsJob() {
        return SchedulerConfiguration.createJobDetail(CleanScreenshotsJob.class);
    }

    public static SimpleTriggerFactoryBean createTrigger(JobDetail jobDetail, long pollFrequencyMs) {
        SimpleTriggerFactoryBean factoryBean = new SimpleTriggerFactoryBean();
        factoryBean.setJobDetail(jobDetail);
        factoryBean.setStartDelay(0L);
        factoryBean.setRepeatInterval(pollFrequencyMs);
        factoryBean.setRepeatCount(-1);
        factoryBean.setMisfireInstruction(4);
        return factoryBean;
    }

    public static CronTriggerFactoryBean createCronTrigger(JobDetail jobDetail, String cronExpression) {
        CronTriggerFactoryBean factoryBean = new CronTriggerFactoryBean();
        factoryBean.setJobDetail(jobDetail);
        factoryBean.setCronExpression(cronExpression);
        factoryBean.setMisfireInstruction(1);
        return factoryBean;
    }

    public static JobDetailFactoryBean createJobDetail(Class jobClass) {
        JobDetailFactoryBean factoryBean = new JobDetailFactoryBean();
        factoryBean.setJobClass(jobClass);
        factoryBean.setDurability(true);
        return factoryBean;
    }

    static /* synthetic */ AutowireCapableBeanFactory access$000(SchedulerConfiguration x0) {
        return x0.context;
    }
}

