/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter;

import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.resolver.PredefinedFilterBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public final class PredefinedFilters {
    private static final Collection<TestItemType> HAS_METHOD_OR_CLASS = Arrays.stream(TestItemType.values()).filter(it -> {
        String name = it.name();
        return name.contains("METHOD") || name.contains("CLASS");
    }).collect(Collectors.toList());
    private static final Map<String, PredefinedFilterBuilder> FILTERS = ImmutableMap.builder().put((Object)"collapsed", (Object)new /* Unavailable Anonymous Inner Class!! */).build();

    private PredefinedFilters() {
    }

    public static boolean hasFilter(String name) {
        return FILTERS.containsKey(name);
    }

    public static Queryable buildFilter(String name, String[] params) {
        PredefinedFilterBuilder builder = (PredefinedFilterBuilder)FILTERS.get(name);
        return builder.buildFilter(params);
    }

    static /* synthetic */ Collection access$000() {
        return HAS_METHOD_OR_CLASS;
    }
}

