/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.filter.IGetUserFilterHandler;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.UserFilterResourceAssembler;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.filter.UserFilterResource;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetUserFilterHandler
implements IGetUserFilterHandler {
    @Autowired
    private UserFilterRepository filterRepository;
    @Autowired
    private UserFilterResourceAssembler resourceAssembler;
    private final Function<UserFilter, SharedEntity> TO_SHARED_ENTITY = filter -> {
        SharedEntity sharedEntity = new SharedEntity();
        sharedEntity.setId(filter.getId());
        sharedEntity.setName(filter.getName());
        Optional.ofNullable(filter.getAcl()).ifPresent(acl -> sharedEntity.setOwner(acl.getOwnerUserId()));
        sharedEntity.setDescription(filter.getDescription());
        return sharedEntity;
    };

    public UserFilterResource getFilter(String userName, String filterId, String projectName) {
        UserFilter userFilter = (UserFilter)this.filterRepository.findOne((Serializable)((Object)filterId));
        BusinessRule.expect((Object)userFilter, (Predicate)Predicates.notNull()).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterId, userName});
        AclUtils.isPossibleToRead((Acl)userFilter.getAcl(), (String)userName, (String)projectName);
        BusinessRule.expect((Object)userFilter.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        return (UserFilterResource)UserFilterConverter.TO_RESOURCE.apply(userFilter);
    }

    public List<UserFilterResource> getOwnFilters(String userName, Filter filter, String projectName) {
        List filters = this.filterRepository.findFilters(userName, projectName, Shareable.NAME_OWNER_SORT, false);
        return filters.stream().map(UserFilterConverter.TO_RESOURCE).collect(Collectors.toList());
    }

    public List<UserFilterResource> getSharedFilters(String userName, Filter filter, String projectName) {
        List filters = this.filterRepository.findFilters(userName, projectName, Shareable.NAME_OWNER_SORT, true);
        return filters.stream().map(UserFilterConverter.TO_RESOURCE).collect(Collectors.toList());
    }

    public Iterable<UserFilterResource> getFilters(String userName, Pageable pageable, Filter filter, String projectName) {
        Page filters = this.filterRepository.findAllByFilter(filter, pageable, projectName, userName);
        return (Iterable)PagedResourcesAssembler.pageConverter((Function)UserFilterConverter.TO_RESOURCE).apply(filters);
    }

    public Iterable<SharedEntity> getFiltersNames(String userName, String projectName, boolean isShared) {
        List filters = this.filterRepository.findFilters(userName, projectName, Shareable.NAME_OWNER_SORT, isShared);
        return filters.stream().map(this.TO_SHARED_ENTITY).collect(Collectors.toList());
    }

    public List<UserFilterResource> getFilters(String projectName, String[] ids, String userName) {
        List filters = this.filterRepository.findAvailableFilters(projectName, ids, userName);
        return this.resourceAssembler.toResources((Iterable)filters);
    }
}

