/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl.junit;

import com.epam.ta.reportportal.core.imprt.impl.DateUtils;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategy;
import com.epam.ta.reportportal.core.imprt.impl.junit.ParseResults;
import com.epam.ta.reportportal.core.imprt.impl.junit.XunitParseJob;
import com.epam.ta.reportportal.core.launch.IFinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.IStartLaunchHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XunitImportStrategy
implements ImportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(XunitImportStrategy.class);
    private static final Date initialStartTime = new Date(0L);
    private static final ExecutorService service = Executors.newFixedThreadPool(5);
    private static final String XML_REGEX = ".*xml";
    private static final Predicate<ZipEntry> isFile = zipEntry -> !zipEntry.isDirectory();
    private static final Predicate<ZipEntry> isXml = zipEntry -> zipEntry.getName().matches(XML_REGEX);
    @Autowired
    private Provider<XunitParseJob> xmlParseJobProvider;
    @Autowired
    private IStartLaunchHandler startLaunchHandler;
    @Autowired
    private IFinishLaunchHandler finishLaunchHandler;
    @Autowired
    private LaunchRepository launchRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importLaunch(String projectId, String userName, File file) {
        try {
            String string = this.processZipFile(file, projectId, userName);
            return string;
        }
        finally {
            try {
                if (null != file) {
                    file.delete();
                }
            }
            catch (Exception e) {
                LOGGER.error("File '{}' was not successfully deleted.", (Object)file.getName(), (Object)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processZipFile(File zip, String projectId, String userName) {
        String savedLaunchId = null;
        try (ZipFile zipFile = new ZipFile(zip);){
            String launchId;
            savedLaunchId = launchId = this.startLaunch(projectId, userName, zip.getName().substring(0, zip.getName().indexOf(".zip")));
            CompletableFuture[] futures = (CompletableFuture[])zipFile.stream().filter(isFile.and(isXml)).map(zipEntry -> {
                XunitParseJob job = ((XunitParseJob)this.xmlParseJobProvider.get()).withParameters(projectId, launchId, userName, this.getEntryStream(zipFile, zipEntry));
                return CompletableFuture.supplyAsync(() -> ((XunitParseJob)job).call(), service);
            }).toArray(CompletableFuture[]::new);
            ParseResults parseResults = this.processResults(futures);
            this.finishLaunch(launchId, projectId, userName, parseResults);
            String string = launchId;
            return string;
        }
        catch (Exception e) {
            this.updateBrokenLaunch(savedLaunchId);
            throw new ReportPortalException(ErrorType.IMPORT_FILE_ERROR, new Object[]{this.cleanMessage(e)});
        }
    }

    private InputStream getEntryStream(ZipFile file, ZipEntry zipEntry) {
        try {
            return file.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.IMPORT_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    private ParseResults processResults(CompletableFuture[] futures) {
        ParseResults results = new ParseResults();
        Arrays.stream(futures).map(it -> (ParseResults)it.join()).forEach(res -> {
            results.checkAndSetStartLaunchTime(res.getStartTime());
            results.increaseDuration(res.getDuration());
        });
        return results;
    }

    private String startLaunch(String projectId, String userName, String launchName) {
        StartLaunchRQ startLaunchRQ = new StartLaunchRQ();
        startLaunchRQ.setStartTime(initialStartTime);
        startLaunchRQ.setName(launchName);
        startLaunchRQ.setMode(Mode.DEFAULT);
        return this.startLaunchHandler.startLaunch(userName, projectId, startLaunchRQ).getId();
    }

    private void finishLaunch(String launchId, String projectId, String userName, ParseResults results) {
        FinishExecutionRQ finishExecutionRQ = new FinishExecutionRQ();
        finishExecutionRQ.setEndTime(results.getEndTime());
        this.finishLaunchHandler.finishLaunch(launchId, finishExecutionRQ, projectId, userName);
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        launch.setStartTime(DateUtils.toDate((LocalDateTime)results.getStartTime()));
        this.launchRepository.partialUpdate((Object)launch);
    }

    private String cleanMessage(Exception e) {
        if (e.getCause() != null) {
            return e.getCause().getMessage();
        }
        return e.getMessage();
    }

    private void updateBrokenLaunch(String savedLaunchId) {
        if (savedLaunchId != null) {
            Launch launch = new Launch();
            launch.setId(savedLaunchId);
            launch.setStatistics(null);
            launch.setStartTime(Calendar.getInstance().getTime());
            this.launchRepository.partialUpdate((Object)launch);
        }
    }
}

