/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.history;

import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.FilterConditionUtils;

class HistoryUtils {
    public static final FilterCondition STATUS_CONDITION = new FilterCondition(Condition.IN, false, Status.PASSED.toString() + "," + Status.FAILED.toString() + "," + Status.STOPPED.toString(), "status");

    private HistoryUtils() {
    }

    public static Filter getLaunchSelectionFilter(String launchName, String projectName, String number, boolean showBrokenLaunches) {
        Filter filter = new Filter(Launch.class, Condition.EQUALS, false, launchName, "name");
        FilterCondition projectCondition = new FilterCondition(Condition.EQUALS, false, projectName, "project");
        FilterCondition startTimeCondition = new FilterCondition(Condition.LOWER_THAN_OR_EQUALS, false, number, "number");
        filter.addCondition(projectCondition);
        filter.addCondition(startTimeCondition);
        filter.addCondition(FilterConditionUtils.LAUNCH_IN_DEFAULT_MODE());
        if (!showBrokenLaunches) {
            filter.addCondition(STATUS_CONDITION);
        }
        return filter;
    }
}

