/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service(value="jasperRender")
class JasperReportRender {
    private static final Logger LOGGER = LoggerFactory.getLogger(JasperReportRender.class);
    private static final String REPORT_JRXML_TEMPLATE = "classpath:/templates/report/report.jrxml";
    private JasperReport jasperReport;

    @Autowired
    public JasperReportRender(ResourceLoader resourceLoader) throws JRException, IOException {
        Resource reportTemplate = resourceLoader.getResource(REPORT_JRXML_TEMPLATE);
        Preconditions.checkArgument((boolean)reportTemplate.exists());
        InputStream inputStream = reportTemplate.getInputStream();
        JasperDesign jasperDesign = JRXmlLoader.load((InputStream)inputStream);
        this.jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
    }

    JasperPrint generateReportPrint(Map<String, Object> params, JRDataSource datasource) {
        try {
            return JasperFillManager.fillReport((JasperReport)this.jasperReport, params, (JRDataSource)datasource);
        }
        catch (JRException e) {
            LOGGER.error("Unable to generate Report", (Throwable)e);
            return new JasperPrint();
        }
    }
}

