/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategyLatest;
import com.epam.ta.reportportal.core.widget.content.WidgetContentProvider;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareLaunchesFilterStrategy
implements BuildFilterStrategyLatest {
    @Autowired
    private WidgetContentProvider widgetContentProvider;

    public Map<String, List<ChartObject>> buildFilterAndLoadContent(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        if (null == userFilter) {
            return Collections.emptyMap();
        }
        Filter filter = this.extendFilter(userFilter.getFilter(), projectName);
        return this.widgetContentProvider.getChartContent(projectName, filter, userFilter.getSelectionOptions(), contentOptions);
    }

    public Map<String, List<ChartObject>> loadContentOfLatest(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        if (null == userFilter) {
            return Collections.emptyMap();
        }
        Filter filter = this.extendFilter(userFilter.getFilter(), projectName);
        return this.widgetContentProvider.getChartContent(projectName, filter, userFilter.getSelectionOptions(), contentOptions);
    }

    private Filter extendFilter(Filter filter, String projectName) {
        if (filter.getTarget().equals(Launch.class)) {
            filter.addCondition(new FilterCondition(Condition.EQUALS, false, Mode.DEFAULT.name(), "mode"));
            filter.addCondition(new FilterCondition(Condition.NOT_EQUALS, false, Status.IN_PROGRESS.name(), "status"));
            filter.addCondition(new FilterCondition(Condition.EQUALS, false, projectName, "project"));
        }
        return filter;
    }
}

