/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.events.ExternalSystemCreatedEvent;
import com.epam.ta.reportportal.events.ExternalSystemDeletedEvent;
import com.epam.ta.reportportal.events.ExternalSystemUpdatedEvent;
import com.epam.ta.reportportal.events.ProjectExternalSystemsDeletedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ExternalSystemActivityHandler {
    private final ActivityRepository activityRepository;

    @Autowired
    public ExternalSystemActivityHandler(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onExternalSystemCreated(ExternalSystemCreatedEvent event) {
        ExternalSystem externalSystem = event.getExternalSystem();
        String name = externalSystem.getExternalSystemType() + ":" + externalSystem.getProject();
        Activity activity = new ActivityBuilder().addObjectName(name).addObjectType(ActivityObjectType.EXTERNAL_SYSTEM).addLoggedObjectRef(externalSystem.getId()).addUserRef(event.getCreatedBy()).addActionType(ActivityEventType.CREATE_BTS).addProjectRef(externalSystem.getProjectRef()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)"", (String)name))).get();
        this.activityRepository.save((Object)activity);
    }

    @EventListener
    public void onExternalSystemUpdate(ExternalSystemUpdatedEvent event) {
        ExternalSystem externalSystem = event.getExternalSystem();
        if (externalSystem != null) {
            String name = externalSystem.getExternalSystemType() + ":" + externalSystem.getProject();
            Activity activity = new ActivityBuilder().addObjectName(name).addObjectType(ActivityObjectType.EXTERNAL_SYSTEM).addLoggedObjectRef(externalSystem.getId()).addUserRef(event.getUpdatedBy()).addActionType(ActivityEventType.UPDATE_BTS).addProjectRef(externalSystem.getProjectRef()).get();
            this.activityRepository.save((Object)activity);
        }
    }

    @EventListener
    public void onExternalSystemDelete(ExternalSystemDeletedEvent event) {
        ExternalSystem externalSystem = event.getExternalSystem();
        if (externalSystem != null) {
            String name = externalSystem.getExternalSystemType() + ":" + externalSystem.getProject();
            Activity activity = new ActivityBuilder().addObjectName(name).addObjectType(ActivityObjectType.EXTERNAL_SYSTEM).addLoggedObjectRef(externalSystem.getId()).addUserRef(event.getDeletedBy()).addActionType(ActivityEventType.DELETE_BTS).addProjectRef(externalSystem.getProjectRef()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)name, (String)""))).get();
            this.activityRepository.save((Object)activity);
        }
    }

    @EventListener
    public void onProjectExternalSystemsDelete(ProjectExternalSystemsDeletedEvent event) {
        List activities;
        Iterable externalSystems = event.getExternalSystems();
        if (null != externalSystems && !(activities = StreamSupport.stream(externalSystems.spliterator(), false).map(externalSystem -> {
            String name = externalSystem.getExternalSystemType() + ":" + externalSystem.getProject();
            return new ActivityBuilder().addObjectName(name).addObjectType(ActivityObjectType.EXTERNAL_SYSTEM).addLoggedObjectRef(externalSystem.getId()).addUserRef(event.getDeletedBy()).addActionType(ActivityEventType.DELETE_BTS).addProjectRef(event.getProject()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)name, (String)""))).get();
        }).collect(Collectors.toList())).isEmpty()) {
            this.activityRepository.save(activities);
        }
    }
}

