/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.commons.SendCase;
import com.epam.ta.reportportal.core.analyzer.IIssuesAnalyzer;
import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.core.launch.IRetriesLaunchHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.AnalyzeMode;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.project.email.EmailSenderCase;
import com.epam.ta.reportportal.database.entity.project.email.ProjectEmailConfig;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.events.LaunchFinishedEvent;
import com.epam.ta.reportportal.events.handler.LaunchFinishedEventHandler;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class LaunchFinishedEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaunchFinishedEventHandler.class);
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final IIssuesAnalyzer analyzerService;
    private final ILogIndexer logIndexer;
    private final IRetriesLaunchHandler retriesLaunchHandler;
    private final MailServiceFactory emailServiceFactory;
    private final UserRepository userRepository;
    private final Provider<HttpServletRequest> currentRequest;

    @Autowired
    public LaunchFinishedEventHandler(TestItemRepository testItemRepository, LaunchRepository launchRepository, IIssuesAnalyzer analyzerService, ILogIndexer logIndexer, IRetriesLaunchHandler retriesLaunchHandler, MailServiceFactory emailServiceFactory, UserRepository userRepository, Provider<HttpServletRequest> currentRequest) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.analyzerService = analyzerService;
        this.logIndexer = logIndexer;
        this.retriesLaunchHandler = retriesLaunchHandler;
        this.emailServiceFactory = emailServiceFactory;
        this.userRepository = userRepository;
        this.currentRequest = currentRequest;
    }

    @EventListener
    public void onApplicationEvent(LaunchFinishedEvent event) {
        this.afterFinishLaunch(event.getProject(), event.getLaunch());
    }

    private void afterFinishLaunch(Project project, Launch launch) {
        if (null == project || null == launch) {
            return;
        }
        this.retriesLaunchHandler.handleRetries(launch);
        Optional emailService = this.emailServiceFactory.getDefaultEmailService(project.getConfiguration().getEmailConfig());
        if (Mode.DEBUG.equals((Object)launch.getMode())) {
            return;
        }
        this.logIndexer.indexLogs(launch.getId(), this.testItemRepository.findTestItemWithIssues(launch.getId()));
        if (!BooleanUtils.toBoolean((Boolean)project.getConfiguration().getIsAutoAnalyzerEnabled())) {
            emailService.ifPresent(service -> this.sendEmailRightNow(launch, project, service));
            return;
        }
        List toInvestigateItems = this.testItemRepository.findInIssueTypeItems(TestItemIssueType.TO_INVESTIGATE.getLocator(), launch.getId());
        this.analyzerService.analyze(launch, toInvestigateItems, Optional.ofNullable(project.getConfiguration().getAnalyzerMode()).orElse(AnalyzeMode.BY_LAUNCH_NAME));
        Launch freshLaunch = (Launch)this.launchRepository.findOne((Serializable)((Object)launch.getId()));
        emailService.ifPresent(it -> this.sendEmailRightNow(freshLaunch, project, it));
    }

    private static double getSuccessRate(Launch launch) {
        Double ti = launch.getStatistics().getIssueCounter().getToInvestigateTotal().doubleValue();
        Double pb = launch.getStatistics().getIssueCounter().getProductBugTotal().doubleValue();
        Double si = launch.getStatistics().getIssueCounter().getSystemIssueTotal().doubleValue();
        Double ab = launch.getStatistics().getIssueCounter().getAutomationBugTotal().doubleValue();
        Double total = launch.getStatistics().getExecutionCounter().getTotal().doubleValue();
        return total == 0.0 ? total : (ti + pb + si + ab) / total;
    }

    static boolean isSuccessRateEnough(Launch launch, SendCase option) {
        switch (1.$SwitchMap$com$epam$ta$reportportal$commons$SendCase[option.ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return launch.getStatus().equals((Object)Status.FAILED);
            }
            case 3: {
                return launch.getStatistics().getIssueCounter().getToInvestigateTotal() > 0;
            }
            case 4: {
                return LaunchFinishedEventHandler.getSuccessRate((Launch)launch) > 0.1;
            }
            case 5: {
                return LaunchFinishedEventHandler.getSuccessRate((Launch)launch) > 0.2;
            }
            case 6: {
                return LaunchFinishedEventHandler.getSuccessRate((Launch)launch) > 0.5;
            }
        }
        return false;
    }

    static boolean isLaunchNameMatched(Launch launch, EmailSenderCase oneCase) {
        List configuredNames = oneCase.getLaunchNames();
        return null == configuredNames || configuredNames.isEmpty() || configuredNames.contains(launch.getName());
    }

    @VisibleForTesting
    static boolean isTagsMatched(Launch launch, EmailSenderCase oneCase) {
        return null == oneCase.getTags() || oneCase.getTags().isEmpty() || null != launch.getTags() && launch.getTags().containsAll(oneCase.getTags());
    }

    void sendEmailRightNow(Launch launch, Project project, EmailService emailService) {
        ProjectEmailConfig projectConfig = project.getConfiguration().getEmailConfig();
        for (EmailSenderCase one : projectConfig.getEmailCases()) {
            Optional option = SendCase.findByName((String)one.getSendCase());
            boolean successRate = LaunchFinishedEventHandler.isSuccessRateEnough((Launch)launch, (SendCase)((SendCase)option.get()));
            boolean matchedNames = LaunchFinishedEventHandler.isLaunchNameMatched((Launch)launch, (EmailSenderCase)one);
            boolean matchedTags = LaunchFinishedEventHandler.isTagsMatched((Launch)launch, (EmailSenderCase)one);
            List recipients = one.getRecipients();
            if (!successRate || !matchedNames || !matchedTags) continue;
            String[] recipientsArray = this.findRecipients(launch.getUserRef(), recipients);
            try {
                String basicURL = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest((HttpServletRequest)this.currentRequest.get())).replacePath(String.format("/#%s", project.getName())).build().toUriString();
                emailService.sendLaunchFinishNotification(recipientsArray, basicURL, launch, project.getConfiguration());
            }
            catch (Exception e) {
                LOGGER.error("Unable to send email. Error: \n{}", (Throwable)e);
            }
        }
    }

    String[] findRecipients(String owner, List<String> recipients) {
        return (String[])recipients.stream().map(recipient -> {
            if (recipient.contains("@")) {
                return recipient;
            }
            String toFind = recipient.equals(ProjectUtils.getOwner()) ? owner : recipient;
            User user = (User)this.userRepository.findOne((Serializable)((Object)toFind));
            if (user != null) {
                return user.getEmail();
            }
            return null;
        }).filter(Objects::nonNull).distinct().toArray(String[]::new);
    }
}

