/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.migration;

import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import com.mongodb.DBObject;
import java.util.LinkedHashMap;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

@ChangeLog(order="3.2")
public class ChangeSets_3_2 {
    private static final String USERS = "users";
    private static final String ID = "_id";
    private static final String PROJECT_COLLECTION = "project";

    @ChangeSet(order="3.2-1", id="v3.2-Replace embedded users collection with array", author="pbortnik")
    public void replaceProjectUsers(MongoTemplate mongoTemplate) {
        Query q = new Query((CriteriaDefinition)Criteria.where((String)USERS).exists(true));
        q.fields().include(ID).include(USERS);
        mongoTemplate.stream(q, DBObject.class, PROJECT_COLLECTION).forEachRemaining(dbo -> {
            DBObject history = (DBObject)dbo.get(USERS);
            Update u = new Update();
            LinkedHashMap[] dbArray = new LinkedHashMap[history.keySet().size()];
            int i = 0;
            for (String key : history.keySet()) {
                DBObject o = (DBObject)history.get(key);
                LinkedHashMap<String, String> res = new LinkedHashMap<String, String>(o.keySet().size() + 1);
                res.put("login", key);
                res.putAll(o.toMap());
                dbArray[i] = res;
                ++i;
            }
            u.set(USERS, (Object)dbArray);
            mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)ID).is(dbo.get(ID))), u, PROJECT_COLLECTION);
        });
    }
}

