/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.migration;

import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

@ChangeLog(order="4.0")
public class ChangeSets_4_0 {
    @ChangeSet(order="4.0-1", id="v.4.0-Update refactored widgets", author="pbortnik")
    public void updateWidgets(MongoTemplate mongoTemplate) {
        String collection = "widget";
        Criteria criteria = new Criteria();
        Query query = Query.query((CriteriaDefinition)criteria.orOperator(new Criteria[]{Criteria.where((String)"contentOptions.type").is((Object)"line_chart").and("contentOptions.gadgetType").is((Object)"old_line_chart"), Criteria.where((String)"contentOptions.type").is((Object)"trends_chart").and("contentOptions.gadgetType").is((Object)"statistic_trend")}));
        query.fields().include("_id");
        query.fields().include("contentOptions");
        String[] viewMode = new String[1];
        mongoTemplate.stream(query, DBObject.class, "widget").forEachRemaining(widget -> {
            Update update = new Update();
            DBObject contentOptions = (DBObject)widget.get("contentOptions");
            BasicDBObject widgetOptions = (BasicDBObject)contentOptions.get("widgetOptions");
            String type = (String)contentOptions.get("type");
            update.set("contentOptions.type", (Object)"trends_chart");
            update.set("contentOptions.gadgetType", (Object)"statistic_trend");
            String string = viewMode[0] = "line_chart".equals(type) ? "areaChartMode" : "barMode";
            if (widgetOptions != null) {
                widgetOptions.append("viewMode", (Object)viewMode);
            } else {
                widgetOptions = new BasicDBObject("viewMode", (Object)viewMode);
            }
            update.set("contentOptions.widgetOptions", (Object)widgetOptions);
            mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(widget.get("_id"))), update, "widget");
        });
    }

    @ChangeSet(order="4.0-2", id="v.4.0-Update filter model", author="pbortnik")
    public void updateFilters(MongoTemplate mongoTemplate) {
        String collection = "userFilter";
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"selectionOptions").exists(true));
        q.fields().include("_id");
        q.fields().include("selectionOptions");
        mongoTemplate.stream(q, DBObject.class, "userFilter").forEachRemaining(filter -> {
            Update update = new Update();
            Map map = (Map)filter.get("selectionOptions");
            String sortingColumnName = (String)map.get("sortingColumnName");
            Boolean isAsc = (Boolean)map.get("isAsc");
            ArrayList selectionOrders = Lists.newArrayList((Object[])new BasicDBObject[]{new BasicDBObject("isAsc", (Object)isAsc).append("sortingColumnName", (Object)sortingColumnName)});
            if (sortingColumnName.equals("start_time")) {
                selectionOrders.add(new BasicDBObject("isAsc", (Object)isAsc).append("sortingColumnName", (Object)"number"));
            }
            update.set("selectionOptions", (Object)new BasicDBObject("pageNumber", map.get("pageNumber")).append("orders", (Object)selectionOrders));
            mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(filter.get("_id"))), update, "userFilter");
        });
    }

    @ChangeSet(order="4.0-3", id="v4.0-Add log indexing checkpoint ID", author="isharamet")
    public void addLogIndexingCheckpoint(MongoTemplate mongoTemplate) {
        mongoTemplate.createCollection("logIndexingCheckpoint");
    }

    @ChangeSet(order="4.0-4", id="v4.1-Update metadata project names to lower case", author="pbortnik")
    public void updateAttachmentsMetadata(MongoTemplate mongoTemplate) {
        String collection = "fs.files";
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"metadata.project").exists(true));
        q.fields().include("_id");
        q.fields().include("metadata.project");
        mongoTemplate.stream(q, DBObject.class, collection).forEachRemaining(o -> {
            Map metadata = (Map)o.get("metadata");
            String project = (String)metadata.get("project");
            if (null != project && !StringUtils.isAllLowerCase((CharSequence)project)) {
                String inLower = project.toLowerCase();
                Update update = new Update();
                update.set("metadata.project", (Object)inLower);
                mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(o.get("_id"))), update, collection);
            }
        });
    }
}

