/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email;

import com.epam.reportportal.commons.template.TemplateEngine;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.user.UserUtils;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.net.UrlEscapers;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class EmailService
extends JavaMailSenderImpl {
    private static final String FINISH_LAUNCH_EMAIL_SUBJECT = " Report Portal Notification: launch '%s' #%s finished";
    private static final String URL_FORMAT = "%s/launches/all";
    private static final String FILTER_TAG_FORMAT = "%s?filter.has.tags=%s";
    private static final String EMAIL_TEMPLATE_PREFIX = "templates/email/";
    private TemplateEngine templateEngine;
    private String from;

    public EmailService(Properties javaMailProperties) {
        super.setJavaMailProperties(javaMailProperties);
    }

    public void sendCreateUserConfirmationEmail(String subject, String[] recipients, String url) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("url", url);
            String text = this.templateEngine.merge("registration-template.ftl", email);
            message.setText(text, true);
            message.addInline("create-user.png", (Resource)this.emailTemplateResource("create-user.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendLaunchFinishNotification(String[] recipients, String url, Launch launch, Project.Configuration settings) {
        String subject = String.format(FINISH_LAUNCH_EMAIL_SUBJECT, launch.getName(), launch.getNumber());
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            String text = this.mergeFinishLaunchText(url, launch, settings);
            message.setText(text, true);
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    @VisibleForTesting
    String mergeFinishLaunchText(String url, Launch launch, Project.Configuration settings) {
        HashMap<String, Object> email = new HashMap<String, Object>();
        String basicUrl = String.format(URL_FORMAT, url);
        email.put("name", launch.getName());
        email.put("number", String.valueOf(launch.getNumber()));
        email.put("description", launch.getDescription());
        email.put("url", String.format("%s/%s", basicUrl, launch.getId()));
        if (!CollectionUtils.isEmpty((Collection)launch.getTags())) {
            email.put("tags", launch.getTags().stream().collect(Collectors.toMap(tag -> tag, tag -> String.format(FILTER_TAG_FORMAT, basicUrl, UrlEscapers.urlPathSegmentEscaper().escape(tag)))));
        }
        email.put("total", launch.getStatistics().getExecutionCounter().getTotal().toString());
        email.put("passed", launch.getStatistics().getExecutionCounter().getPassed().toString());
        email.put("failed", launch.getStatistics().getExecutionCounter().getFailed().toString());
        email.put("skipped", launch.getStatistics().getExecutionCounter().getSkipped().toString());
        email.put("productBugTotal", launch.getStatistics().getIssueCounter().getProductBugTotal().toString());
        email.put("automationBugTotal", launch.getStatistics().getIssueCounter().getAutomationBugTotal().toString());
        email.put("systemIssueTotal", launch.getStatistics().getIssueCounter().getSystemIssueTotal().toString());
        email.put("noDefectTotal", launch.getStatistics().getIssueCounter().getNoDefectTotal().toString());
        email.put("toInvestigateTotal", launch.getStatistics().getIssueCounter().getToInvestigateTotal().toString());
        if (launch.getStatistics().getIssueCounter().getProductBug().entrySet().size() > 1) {
            LinkedHashMap pb = new LinkedHashMap();
            launch.getStatistics().getIssueCounter().getProductBug().forEach((k, v) -> {
                if (!k.equalsIgnoreCase("total")) {
                    pb.put(settings.getByLocator(k), v.toString());
                }
            });
            email.put("pbInfo", pb);
        }
        if (launch.getStatistics().getIssueCounter().getAutomationBug().entrySet().size() > 1) {
            LinkedHashMap ab = new LinkedHashMap();
            launch.getStatistics().getIssueCounter().getAutomationBug().forEach((k, v) -> {
                if (!k.equalsIgnoreCase("total")) {
                    ab.put(settings.getByLocator(k), v.toString());
                }
            });
            email.put("abInfo", ab);
        }
        if (launch.getStatistics().getIssueCounter().getSystemIssue().entrySet().size() > 1) {
            LinkedHashMap si = new LinkedHashMap();
            launch.getStatistics().getIssueCounter().getSystemIssue().forEach((k, v) -> {
                if (!k.equalsIgnoreCase("total")) {
                    si.put(settings.getByLocator(k), v.toString());
                }
            });
            email.put("siInfo", si);
        }
        if (launch.getStatistics().getIssueCounter().getNoDefect().entrySet().size() > 1) {
            LinkedHashMap nd = new LinkedHashMap();
            launch.getStatistics().getIssueCounter().getNoDefect().forEach((k, v) -> {
                if (!k.equalsIgnoreCase("total")) {
                    nd.put(settings.getByLocator(k), v.toString());
                }
            });
            email.put("ndInfo", nd);
        }
        if (launch.getStatistics().getIssueCounter().getToInvestigate().entrySet().size() > 1) {
            LinkedHashMap ti = new LinkedHashMap();
            launch.getStatistics().getIssueCounter().getToInvestigate().forEach((k, v) -> {
                if (!k.equalsIgnoreCase("total")) {
                    ti.put(settings.getByLocator(k), v.toString());
                }
            });
            email.put("tiInfo", ti);
        }
        return this.templateEngine.merge("finish-launch-template.ftl", email);
    }

    public void sendRestorePasswordEmail(String subject, String[] recipients, String url, String login) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("login", login);
            email.put("url", url);
            String text = this.templateEngine.merge("restore-password-template.ftl", email);
            message.setText(text, true);
            message.addInline("restore-password.png", (Resource)this.emailTemplateResource("restore-password.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void sendCreateUserConfirmationEmail(CreateUserRQFull req, String basicUrl) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject("Welcome to Report Portal");
            message.setTo(req.getEmail());
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("url", basicUrl);
            email.put("login", EntityUtils.normalizeId((String)req.getLogin()));
            email.put("password", req.getPassword());
            String text = this.templateEngine.merge("create-user-template.ftl", email);
            message.setText(text, true);
            message.addInline("create-user.png", (Resource)this.emailTemplateResource("create-user.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    private void setFrom(MimeMessageHelper message) throws MessagingException, UnsupportedEncodingException {
        if (!Strings.isNullOrEmpty((String)this.from)) {
            if (this.isAddressValid(this.from)) {
                message.setFrom(this.from);
            } else if (UserUtils.isEmailValid((String)this.getUsername())) {
                message.setFrom(this.getUsername(), this.from);
            }
        }
    }

    private boolean isAddressValid(String from) {
        try {
            InternetAddress.parse((String)from);
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }

    private void attachSocialImages(MimeMessageHelper message) throws MessagingException {
        message.addInline("ic-github.png", (Resource)this.emailTemplateResource("ic-github.png"));
        message.addInline("ic-fb.png", (Resource)this.emailTemplateResource("ic-fb.png"));
        message.addInline("ic-twitter.png", (Resource)this.emailTemplateResource("ic-twitter.png"));
        message.addInline("ic-youtube.png", (Resource)this.emailTemplateResource("ic-youtube.png"));
        message.addInline("ic-vk.png", (Resource)this.emailTemplateResource("ic-vk.png"));
        message.addInline("ic-slack.png", (Resource)this.emailTemplateResource("ic-slack.png"));
    }

    private ClassPathResource emailTemplateResource(String resource) {
        return new ClassPathResource(EMAIL_TEMPLATE_PREFIX + resource);
    }
}

