/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.launch.IGetLaunchHandler;
import com.epam.ta.reportportal.core.project.IGetProjectHandler;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.util.SystemInformatorService;
import com.epam.ta.reportportal.ws.controller.IPluginsController;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.SystemInfoRS;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@Controller
public class PluginController
implements IPluginsController {
    @Autowired
    private IGetLaunchHandler getLaunchMessageHandler;
    @Autowired
    private IGetProjectHandler getProjectHandler;
    @Autowired
    private SystemInformatorService infoService;

    @RequestMapping(value={"/{projectName}/launch/jenkins"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiIgnore
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    public LaunchResource getLaunchByName(@PathVariable String projectName, @SortFor(value=Launch.class) Pageable pageable, @FilterFor(value=Launch.class) Filter filter, Principal principal) {
        return this.getLaunchMessageHandler.getLaunchByName(EntityUtils.normalizeId((String)projectName), pageable, filter, principal.getName());
    }

    @RequestMapping(value={"/heartbeat"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Heartbeat method for Tomcat and MongoDB (authentication required)")
    public OperationCompletionRS heartBeat(HttpServletRequest request, Principal principal) {
        return this.getProjectHandler.isProjectsAvailable();
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiIgnore
    public SystemInfoRS getSystemStatus() {
        return this.infoService.getSystemInformation();
    }
}

