/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.impl;

import com.epam.ta.reportportal.core.analyzer.IAnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.IIssuesAnalyzer;
import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.core.analyzer.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.model.AnalyzedItemRs;
import com.epam.ta.reportportal.core.analyzer.model.IndexLaunch;
import com.epam.ta.reportportal.core.analyzer.model.IndexTestItem;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.AnalyzeMode;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.LogLevel;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.events.ItemIssueTypeDefined;
import com.epam.ta.reportportal.events.TicketAttachedEvent;
import com.epam.ta.reportportal.ws.converter.converters.AnalyzerConfigConverter;
import com.epam.ta.reportportal.ws.converter.converters.IssueConverter;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.issue.IssueDefinition;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class IssuesAnalyzerService
implements IIssuesAnalyzer {
    @Autowired
    private IAnalyzerServiceClient analyzerServiceClient;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private ILogIndexer logIndexer;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private AnalyzerStatusCache analyzerStatusCache;

    public boolean hasAnalyzers() {
        return this.analyzerServiceClient.hasClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(Launch launch, Project project, List<TestItem> testItems, AnalyzeMode analyzeMode) {
        if (launch != null) {
            try {
                this.analyzerStatusCache.analyzeStarted(launch.getId(), project.getName());
                List rqTestItems = this.prepareItems(testItems);
                IndexLaunch rqLaunch = this.prepareLaunch(rqTestItems, launch, project, analyzeMode);
                Map rs = this.analyze(rqLaunch);
                if (!MapUtils.isEmpty((Map)rs)) {
                    List updatedItems = rs.entrySet().stream().flatMap(it -> this.updateTestItems((String)it.getKey(), (List)it.getValue(), testItems, launch.getProjectRef()).stream()).collect(Collectors.toList());
                    this.saveUpdatedItems(updatedItems);
                    this.logIndexer.indexLogs(launch.getId(), updatedItems);
                }
                this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).recalculateStatistics(launch);
            }
            finally {
                this.analyzerStatusCache.analyzeFinished(launch.getId());
            }
        }
    }

    private Map<String, List<AnalyzedItemRs>> analyze(IndexLaunch launch) {
        if (null != launch) {
            return this.analyzerServiceClient.analyze(launch);
        }
        return Collections.emptyMap();
    }

    private IndexLaunch prepareLaunch(List<IndexTestItem> rqTestItems, Launch launch, Project project, AnalyzeMode analyzeMode) {
        if (!rqTestItems.isEmpty()) {
            IndexLaunch rqLaunch = new IndexLaunch();
            rqLaunch.setLaunchId(launch.getId());
            rqLaunch.setLaunchName(launch.getName());
            rqLaunch.setProject(project.getName());
            AnalyzerConfig analyzerConfig = (AnalyzerConfig)AnalyzerConfigConverter.TO_RESOURCE.apply(project.getConfiguration().getAnalyzerConfig());
            analyzerConfig.setAnalyzerMode(analyzeMode.getValue());
            rqLaunch.setAnalyzerConfig(analyzerConfig);
            rqLaunch.setTestItems(rqTestItems);
            return rqLaunch;
        }
        return null;
    }

    private List<IndexTestItem> prepareItems(List<TestItem> testItems) {
        return testItems.stream().map(it -> AnalyzerUtils.fromTestItem((TestItem)it, (List)this.logRepository.findGreaterOrEqualLevel(Collections.singletonList(it.getId()), LogLevel.ERROR))).filter(it -> !CollectionUtils.isEmpty((Collection)it.getLogs())).collect(Collectors.toList());
    }

    private List<TestItem> updateTestItems(String analyzerInstance, List<AnalyzedItemRs> rs, List<TestItem> testItems, String project) {
        HashMap forEvents = new HashMap();
        ArrayList beforeUpdate = new ArrayList(rs.size());
        List<TestItem> updatedItems = rs.stream().map(analyzed -> {
            Optional<TestItem> toUpdate = testItems.stream().filter(item -> item.getId().equals(analyzed.getItemId())).findAny();
            toUpdate.ifPresent(testItem -> {
                beforeUpdate.add(SerializationUtils.clone((Serializable)testItem));
                TestItemIssue issue = new TestItemIssue(analyzed.getIssueType(), null, true);
                issue.setIgnoreAnalyzer(testItem.getIssue().isIgnoreAnalyzer());
                Optional.ofNullable(analyzed.getRelevantItemId()).ifPresent(relevantItemId -> this.fromRelevantItem(issue, relevantItemId));
                IssueDefinition issueDefinition = this.createIssueDefinition(testItem.getId(), issue);
                forEvents.put(issueDefinition, SerializationUtils.clone((Serializable)testItem));
                testItem.setIssue(issue);
            });
            return toUpdate;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        this.eventPublisher.publishEvent((Object)new ItemIssueTypeDefined(forEvents, analyzerInstance, project));
        this.eventPublisher.publishEvent((Object)new TicketAttachedEvent(beforeUpdate, updatedItems, analyzerInstance, project));
        return updatedItems;
    }

    private IssueDefinition createIssueDefinition(String id, TestItemIssue issue) {
        IssueDefinition issueDefinition = new IssueDefinition();
        issueDefinition.setId(id);
        issueDefinition.setIssue((Issue)IssueConverter.TO_MODEL.apply(issue));
        return issueDefinition;
    }

    private void fromRelevantItem(TestItemIssue issue, String relevantItemId) {
        TestItem relevantItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)relevantItemId));
        if (relevantItem != null && relevantItem.getIssue() != null) {
            issue.setIssueDescription(Strings.emptyToNull((String)(Strings.nullToEmpty((String)issue.getIssueDescription()) + Strings.nullToEmpty((String)relevantItem.getIssue().getIssueDescription()))));
            issue.setExternalSystemIssues(Optional.ofNullable(relevantItem.getIssue().getExternalSystemIssues()).orElse(Collections.emptySet()));
        }
    }

    private void saveUpdatedItems(List<TestItem> items) {
        Map<String, TestItemIssue> forUpdate = items.stream().collect(Collectors.toMap(TestItem::getId, TestItem::getIssue));
        if (!forUpdate.isEmpty()) {
            this.testItemRepository.updateItemsIssues(forUpdate);
        }
    }
}

