/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.core.analyzer.strategy.AnalyzeCollectorFactory;
import com.epam.ta.reportportal.core.analyzer.strategy.AnalyzeItemsCollector;
import com.epam.ta.reportportal.core.analyzer.strategy.AnalyzeItemsMode;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.events.ItemIssueTypeDefined;
import com.epam.ta.reportportal.events.TicketAttachedEvent;
import com.epam.ta.reportportal.ws.converter.converters.IssueConverter;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.issue.IssueDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AnalyzeCollectorConfig {
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private ILogIndexer logIndexer;
    private AnalyzeItemsCollector TO_INVESTIGATE_COLLECTOR = (project, username, launchId) -> this.testItemRepository.findInIssueTypeItems(TestItemIssueType.TO_INVESTIGATE.getLocator(), launchId).stream().filter(it -> !it.getIssue().isIgnoreAnalyzer()).collect(Collectors.toList());
    private AnalyzeItemsCollector AUTO_ANALYZED_COLLECTOR = (project, username, launchId) -> {
        List itemsByAutoAnalyzedStatus = this.testItemRepository.findItemsByAutoAnalyzedStatus(true, launchId);
        itemsByAutoAnalyzedStatus = this.resetItems(itemsByAutoAnalyzedStatus, project.getName(), username);
        return itemsByAutoAnalyzedStatus;
    };
    private AnalyzeItemsCollector MANUALLY_ANALYZED_COLLECTOR = (project, username, launchId) -> {
        List itemsByManuallyAnalyzedStatus = this.testItemRepository.findItemsByAutoAnalyzedStatus(false, launchId);
        itemsByManuallyAnalyzedStatus = this.resetItems(itemsByManuallyAnalyzedStatus, project.getName(), username);
        return itemsByManuallyAnalyzedStatus;
    };

    private List<TestItem> resetItems(List<TestItem> items, String projectName, String username) {
        ArrayList before = new ArrayList(items.size());
        this.logIndexer.cleanIndex(projectName, items.stream().map(TestItem::getId).collect(Collectors.toList()));
        HashMap definitions = new HashMap();
        items.forEach(it -> {
            IssueDefinition issueDefinition = new IssueDefinition();
            issueDefinition.setIssue((Issue)IssueConverter.TO_MODEL.apply(new TestItemIssue()));
            issueDefinition.setId(it.getId());
            TestItem beforeItem = (TestItem)SerializationUtils.clone((Serializable)it);
            before.add(beforeItem);
            definitions.put(issueDefinition, beforeItem);
            it.setIssue(new TestItemIssue());
        });
        this.testItemRepository.save(items);
        this.eventPublisher.publishEvent((Object)new ItemIssueTypeDefined(definitions, username, projectName));
        this.eventPublisher.publishEvent((Object)new TicketAttachedEvent(before, items, username, projectName));
        return items;
    }

    @Bean(name={"analyzerModeMapping"})
    public Map<AnalyzeItemsMode, AnalyzeItemsCollector> getAnalyzerModeMapping() {
        HashMap<AnalyzeItemsMode, AnalyzeItemsCollector> mapping = new HashMap<AnalyzeItemsMode, AnalyzeItemsCollector>();
        mapping.put(AnalyzeItemsMode.TO_INVESTIGATE, this.TO_INVESTIGATE_COLLECTOR);
        mapping.put(AnalyzeItemsMode.AUTO_ANALYZED, this.AUTO_ANALYZED_COLLECTOR);
        mapping.put(AnalyzeItemsMode.MANUALLY_ANALYZED, this.MANUALLY_ANALYZED_COLLECTOR);
        return mapping;
    }

    @Bean
    public AnalyzeCollectorFactory analyzeCollectorFactory() {
        return new AnalyzeCollectorFactory(this.getAnalyzerModeMapping());
    }
}

