/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.externalsystem.handler.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.externalsystem.ExternalSystemStrategy;
import com.epam.ta.reportportal.core.externalsystem.StrategyProvider;
import com.epam.ta.reportportal.core.externalsystem.handler.ICreateTicketHandler;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.events.TicketPostedEvent;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.externalsystem.PostTicketRQ;
import com.epam.ta.reportportal.ws.model.externalsystem.Ticket;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class CreateTicketHandler
implements ICreateTicketHandler {
    @Autowired
    private StrategyProvider strategyProvider;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private ExternalSystemRepository externalSystemRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public Ticket createIssue(PostTicketRQ postTicketRQ, String projectName, String systemId, String username) {
        this.validatePostTicketRQ(postTicketRQ);
        List testItems = this.testItemRepository.findByIds(postTicketRQ.getBackLinks().keySet(), (List)ImmutableList.builder().add((Object)"_id").add((Object)"name").build());
        Project project = this.projectRepository.findByName(projectName);
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        List ids = project.getConfiguration().getExternalSystem();
        BusinessRule.expect((Object)ids, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_CONFIGURED, new Object[]{projectName});
        ExternalSystem system = (ExternalSystem)this.externalSystemRepository.findOne((Serializable)((Object)systemId));
        BusinessRule.expect((Object)system, (Predicate)Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{systemId});
        BusinessRule.expect((Object)system.getFields(), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"There aren't any submitted BTS fields!"});
        ExternalSystemStrategy externalSystemStrategy = this.strategyProvider.getStrategy(system.getExternalSystemType());
        Ticket ticket = externalSystemStrategy.submitTicket(postTicketRQ, system);
        testItems.forEach(item -> this.eventPublisher.publishEvent((Object)new TicketPostedEvent(ticket, item.getId(), username, projectName, item.getName())));
        return ticket;
    }

    private void validatePostTicketRQ(PostTicketRQ postTicketRQ) {
        if (postTicketRQ.getIsIncludeLogs() || postTicketRQ.getIsIncludeScreenshots()) {
            BusinessRule.expect((Object)postTicketRQ.getBackLinks(), (Predicate)Predicates.notNull()).verify(ErrorType.UNABLE_POST_TICKET, new Object[]{"Test item id should be specified, when logs required in ticket description."});
        }
    }
}

