/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.imprt.ImportLaunchHandler;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategy;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategyFactoryImpl;
import com.epam.ta.reportportal.core.imprt.impl.ImportType;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.events.ImportFinishedEvent;
import com.epam.ta.reportportal.events.ImportStartedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportLaunchHandlerImpl
implements ImportLaunchHandler {
    private static final String ZIP_REGEX = ".*zip";
    @Autowired
    private ImportStrategyFactoryImpl factory;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public OperationCompletionRS importLaunch(String projectId, String userName, String format, MultipartFile file) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectId));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectId});
        BusinessRule.expect((Object)file.getOriginalFilename(), it -> it.matches(ZIP_REGEX)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Should be a zip archive" + file.getOriginalFilename()});
        ImportType type = ImportType.fromValue((String)format).orElse(null);
        BusinessRule.expect((Object)type, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{format});
        File tempFile = this.transferToTempFile(file);
        this.eventPublisher.publishEvent((Object)new ImportStartedEvent(projectId, userName, file.getOriginalFilename()));
        ImportStrategy strategy = this.factory.getImportLaunch(type);
        String launch = strategy.importLaunch(projectId, userName, tempFile);
        this.eventPublisher.publishEvent((Object)new ImportFinishedEvent(projectId, userName, file.getOriginalFilename()));
        return new OperationCompletionRS("Launch with id = " + launch + " is successfully imported.");
    }

    private File transferToTempFile(MultipartFile file) {
        try {
            File tmp = File.createTempFile(file.getOriginalFilename(), ".zip");
            file.transferTo(tmp);
            return tmp;
        }
        catch (IOException e) {
            throw new ReportPortalException("Error during transferring multipart file", (Throwable)e);
        }
    }
}

