/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.BusinessRuleViolationException;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandlerImpl;
import com.epam.ta.reportportal.core.item.TestItemUtils;
import com.epam.ta.reportportal.core.statistics.StatisticsFacade;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.statistics.StatisticSubType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class FinishTestItemHandlerImpl
implements FinishTestItemHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTestItemHandlerImpl.class);
    private ProjectRepository projectRepository;
    private LaunchRepository launchRepository;
    private TestItemRepository testItemRepository;
    private StatisticsFacadeFactory statisticsFacadeFactory;
    private ExternalSystemRepository externalSystemRepository;

    FinishTestItemHandlerImpl() {
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepo) {
        this.launchRepository = launchRepo;
    }

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Autowired
    public void setStatisticsFacadeFactory(StatisticsFacadeFactory statisticsFacadeFactory) {
        this.statisticsFacadeFactory = statisticsFacadeFactory;
    }

    @Autowired
    public void setExternalSystemRepository(ExternalSystemRepository externalSystemRepository) {
        this.externalSystemRepository = externalSystemRepository;
    }

    public OperationCompletionRS finishTestItem(String testItemId, FinishTestItemRQ finishExecutionRQ, String username) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItemId));
        this.verifyTestItem(testItem, testItemId, finishExecutionRQ, Status.fromValue((String)finishExecutionRQ.getStatus()));
        testItem.setEndTime(finishExecutionRQ.getEndTime());
        if (!Strings.isNullOrEmpty((String)finishExecutionRQ.getDescription())) {
            testItem.setItemDescription(finishExecutionRQ.getDescription());
        }
        if (!CollectionUtils.isEmpty((Collection)finishExecutionRQ.getTags())) {
            testItem.setTags((Set)Sets.newHashSet((Iterable)EntityUtils.trimStrings((Iterable)EntityUtils.update((Iterable)finishExecutionRQ.getTags()))));
        }
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{testItem.getLaunchRef()});
        if (!launch.getUserRef().equalsIgnoreCase(username)) {
            BusinessRule.fail().withError(ErrorType.FINISH_ITEM_NOT_ALLOWED, new Object[]{"You are not launch owner."});
        }
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
        Optional actualStatus = Status.fromValue((String)finishExecutionRQ.getStatus());
        Issue providedIssue = finishExecutionRQ.getIssue();
        StatisticsFacade statisticsFacade = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy());
        if (!actualStatus.isPresent() && testItem.hasChilds()) {
            testItem = statisticsFacade.identifyStatus(testItem);
        } else {
            testItem.setStatus((Status)actualStatus.get());
        }
        if (statisticsFacade.awareIssue(testItem)) {
            testItem = this.awareTestItemIssueTypeFromStatus(testItem, providedIssue, project, username);
        }
        try {
            testItem.setStatistics(null);
            this.testItemRepository.partialUpdate((Object)testItem);
            testItem = statisticsFacade.updateExecutionStatistics(testItem);
            if (null != testItem.getIssue()) {
                statisticsFacade.updateIssueStatistics(testItem);
            }
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating TestItem " + e.getMessage(), (Throwable)e);
        }
        return new OperationCompletionRS("TestItem with ID = '" + testItemId + "' successfully finished.");
    }

    private void verifyTestItem(TestItem testItem, String testItemId, FinishTestItemRQ finishExecutionRQ, Optional<Status> actualStatus) {
        try {
            BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId});
            BusinessRule.expect((Object)testItem, (Predicate)Predicates.not((Predicate)Preconditions.TEST_ITEM_FINISHED)).verify(ErrorType.REPORTING_ITEM_ALREADY_FINISHED, new Object[]{testItem.getId()});
            BusinessRule.expect((Object)(!actualStatus.isPresent() && !testItem.hasChilds() ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.FALSE), (Supplier)Suppliers.formattedSupplier((String)"There is no status provided from request and there are no descendants to check statistics for test item id '{}'", (Object[])new Object[]{testItemId})).verify();
            List descendants = testItem.hasChilds() ? this.testItemRepository.findDescendants(new String[]{testItem.getId()}) : Collections.emptyList();
            Object[] objectArray = new Object[1];
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> testItemId;
            supplierArray[1] = () -> Status.IN_PROGRESS.name();
            supplierArray[2] = () -> descendants.stream().map(TestItem::getName).collect(Collectors.toList());
            objectArray[0] = Suppliers.formattedSupplier((String)"Test item '{}' has descendants with '{}' status. All descendants '{}'", (Supplier[])supplierArray);
            BusinessRule.expect(descendants, (Predicate)Predicates.not((Predicate)Preconditions.HAS_IN_PROGRESS_ITEMS)).verify(ErrorType.FINISH_ITEM_NOT_ALLOWED, objectArray);
            BusinessRule.expect((Object)finishExecutionRQ, (Predicate)Preconditions.finishSameTimeOrLater((Date)testItem.getStartTime())).verify(ErrorType.FINISH_TIME_EARLIER_THAN_START_TIME, new Object[]{finishExecutionRQ.getEndTime(), testItem.getStartTime(), testItemId});
        }
        catch (BusinessRuleViolationException e) {
            BusinessRule.fail().withError(ErrorType.AMBIGUOUS_TEST_ITEM_STATUS, new Object[]{e.getMessage()});
        }
    }

    void verifyIssue(String testItemId, Issue issue, Project.Configuration projectSettings) {
        if (issue != null && !TestItemIssueType.NOT_ISSUE_FLAG.getValue().equalsIgnoreCase(issue.getIssueType())) {
            BusinessRule.expect((Object)projectSettings.getByLocator(issue.getIssueType()), (Predicate)Predicates.notNull()).verify(ErrorType.AMBIGUOUS_TEST_ITEM_STATUS, new Object[]{Suppliers.formattedSupplier((String)"Invalid test item issue type definition '{}' is requested for item '{}'. Valid issue types locators are: {}", (Object[])new Object[]{issue.getIssueType(), testItemId, projectSettings.getSubTypes().values().stream().flatMap(Collection::stream).map(StatisticSubType::getLocator).collect(Collectors.toList())})});
        }
    }

    TestItem awareTestItemIssueTypeFromStatus(TestItem testItem, Issue providedIssue, Project project, String submitter) {
        if (Status.FAILED.equals((Object)testItem.getStatus()) || Status.SKIPPED.equals((Object)testItem.getStatus())) {
            if (null != providedIssue) {
                String issueType;
                this.verifyIssue(testItem.getId(), providedIssue, project.getConfiguration());
                if (!CollectionUtils.isEmpty((Collection)providedIssue.getExternalSystemIssues())) {
                    this.verifyExternalSystemIssues(providedIssue.getExternalSystemIssues(), project.getConfiguration());
                    providedIssue.getExternalSystemIssues().forEach(it -> {
                        it.setSubmitter(submitter);
                        it.setSubmitDate(Long.valueOf(new Date().getTime()));
                    });
                }
                if (!(issueType = providedIssue.getIssueType()).equalsIgnoreCase(TestItemIssueType.NOT_ISSUE_FLAG.getValue())) {
                    TestItemIssue issue = new TestItemIssue(project.getConfiguration().getByLocator(issueType).getLocator(), providedIssue.getComment());
                    issue.setExternalSystemIssues((Set)Optional.ofNullable(providedIssue.getExternalSystemIssues()).map(issues -> issues.stream().peek(it -> BusinessRule.expect((Object)this.externalSystemRepository.exists((Serializable)((Object)it.getExternalSystemId())), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{it.getExternalSystemId()})).map(TestItemUtils.externalIssueDtoConverter((String)submitter)).collect(Collectors.toSet())).orElse(null));
                    issue.setIgnoreAnalyzer(BooleanUtils.toBoolean((Boolean)providedIssue.getIgnoreAnalyzer()));
                    testItem.setIssue(issue);
                }
            } else {
                testItem.setIssue(new TestItemIssue());
            }
        }
        return testItem;
    }

    private void verifyExternalSystemIssues(Set<Issue.ExternalSystemIssue> externalSystemIssues, Project.Configuration projectSettings) {
        BusinessRule.expect((Object)externalSystemIssues.stream().map(Issue.ExternalSystemIssue::getExternalSystemId).anyMatch(Objects::isNull), Predicate.isEqual(false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"External system id. Available ids: " + projectSettings.getExternalSystem().stream().collect(Collectors.joining(", ", "'", "'"))});
    }
}

